/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.HistoricalKey;

public class SubstitutionKey
extends HistoricalKey {
    public static final String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "a keyword";
    public static final String DEFAULT_KEYWORD_STRING = "keyword";

    public void init(String keyspec) throws Exception {
        super.initKey(keyspec, true);
        this.blocksize = 1;
    }

    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception {
        if (alpha1 == null || alpha2 == null) {
            throw new Exception("SubstitutionKey.init(): Null alphabet reference passed");
        }
        super.initKey(keyword, alpha1, alpha2);
        this.blocksize = 1;
    }

    protected void initKeyArrays() throws Exception {
        if (this.alphabet.getSize() != this.cipherAlphabet.getSize()) {
            throw new Exception("ERROR: Plain and cipher alphabets must be the same size");
        }
        int permutationType = 0;
        int indx = this.keyword.indexOf(44);
        if (indx != -1) {
            permutationType = Integer.parseInt(this.keyword.substring(indx + 1));
            this.keyword = this.keyword.substring(0, indx);
        }
        switch (permutationType) {
            case 0: {
                this.defaultPermutationGenerator();
                break;
            }
            case 1: {
                this.reversePermutationGenerator();
                break;
            }
            case 2: {
                this.middlePermutationGenerator();
                break;
            }
            default: {
                this.defaultPermutationGenerator();
            }
        }
    }

    protected void defaultPermutationGenerator() throws Exception {
        char ch;
        this.plainKey = new char[this.alphabet.getSize()];
        this.cipherKey = this.cipherAlphabet != this.alphabet ? new char[this.cipherAlphabet.getSize()] : new char[this.alphabet.getSize()];
        StringBuffer keychars = new StringBuffer();
        int k = 0;
        while (k < this.keyword.length()) {
            ch = this.keyword.charAt(k);
            if (this.cipherAlphabet.isInAlphabet(ch)) {
                keychars.append(ch);
            }
            ++k;
        }
        String keycharStr = keychars.toString();
        int k2 = 0;
        while (k2 < this.cipherAlphabet.getSize()) {
            ch = this.cipherAlphabet.intToChar(k2);
            if (keycharStr.indexOf(ch) == -1) {
                keychars.append(ch);
            }
            ++k2;
        }
        if (keychars.length() != this.cipherKey.length) {
            throw new Exception("ERROR: Unable to construct alphabets from keyword " + this.keyword);
        }
        k2 = 0;
        while (k2 < keychars.length()) {
            this.cipherKey[k2] = ch = keychars.charAt(k2);
            this.plainKey[this.cipherAlphabet.charToInt((char)ch)] = this.alphabet.intToChar(k2);
            ++k2;
        }
    }

    protected void reversePermutationGenerator() throws Exception {
        char ch;
        System.out.println("Reverse Keyword = " + this.keyword);
        this.plainKey = new char[this.alphabet.getSize()];
        this.cipherKey = this.cipherAlphabet != this.alphabet ? new char[this.cipherAlphabet.getSize()] : new char[this.alphabet.getSize()];
        StringBuffer keychars = new StringBuffer();
        int k = 0;
        while (k < this.keyword.length()) {
            ch = this.keyword.charAt(k);
            if (this.cipherAlphabet.isInAlphabet(ch)) {
                keychars.append(ch);
            }
            ++k;
        }
        String keycharStr = keychars.toString();
        StringBuffer unusedAlphabet = new StringBuffer();
        int k2 = 0;
        while (k2 < this.cipherAlphabet.getSize()) {
            ch = this.cipherAlphabet.intToChar(k2);
            if (keycharStr.indexOf(ch) == -1) {
                unusedAlphabet.append(ch);
            }
            ++k2;
        }
        StringBuffer reversedAlphabet = unusedAlphabet.reverse();
        keychars = reversedAlphabet.append(keychars);
        System.out.println("Keychars rev = " + keychars);
        if (keychars.length() != this.cipherKey.length) {
            throw new Exception("ERROR: Unable to construct alphabets from keyword " + this.keyword);
        }
        int k3 = 0;
        while (k3 < keychars.length()) {
            this.cipherKey[k3] = ch = keychars.charAt(k3);
            this.plainKey[this.cipherAlphabet.charToInt((char)ch)] = this.alphabet.intToChar(k3);
            ++k3;
        }
    }

    protected void middlePermutationGenerator() throws Exception {
        char ch;
        System.out.println("Middle Keyword = " + this.keyword);
        this.plainKey = new char[this.alphabet.getSize()];
        this.cipherKey = this.cipherAlphabet != this.alphabet ? new char[this.cipherAlphabet.getSize()] : new char[this.alphabet.getSize()];
        StringBuffer keychars = new StringBuffer();
        int k = 0;
        while (k < this.keyword.length()) {
            ch = this.keyword.charAt(k);
            if (this.cipherAlphabet.isInAlphabet(ch)) {
                keychars.append(ch);
            }
            ++k;
        }
        String keycharStr = keychars.toString();
        StringBuffer unusedAlphabet = new StringBuffer();
        int k2 = 0;
        while (k2 < this.cipherAlphabet.getSize()) {
            ch = this.cipherAlphabet.intToChar(k2);
            if (keycharStr.indexOf(ch) == -1) {
                unusedAlphabet.append(ch);
            }
            ++k2;
        }
        unusedAlphabet.insert(unusedAlphabet.length() / 2, keycharStr);
        keychars = new StringBuffer(unusedAlphabet);
        System.out.println("Keychars = " + keychars);
        if (keychars.length() != this.cipherKey.length) {
            throw new Exception("ERROR: Unable to construct alphabets from keyword " + this.keyword);
        }
        k2 = 0;
        while (k2 < keychars.length()) {
            this.cipherKey[k2] = ch = keychars.charAt(k2);
            this.plainKey[this.cipherAlphabet.charToInt((char)ch)] = this.alphabet.intToChar(k2);
            ++k2;
        }
    }

    public String getAlgorithm() {
        return "Substitution";
    }
}

