/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.BlockCipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.TranspositionKey;

public class TranspositionEngine
extends BlockCipher {
    private TranspositionKey key;
    private String keyword;
    private String invertedKeyword;

    public TranspositionEngine() {
        this.alphabetRangeOptions = "111111/111111";
    }

    protected void engineInit(HistoricalKey hKey) throws Exception {
        if (!(hKey instanceof TranspositionKey)) {
            throw new Exception("InvalidKey: Transposition requires TranspositionKey");
        }
        this.key = (TranspositionKey)hKey;
        this.alphabet = this.key.getAlphabet();
        this.cipherAlphabet = this.key.getCTAlphabet();
        this.blocksize = this.key.getBlocksize();
        this.keyword = this.key.getKeyword();
        this.invertedKeyword = this.key.getInvertedKeyword();
    }

    public String engineEncode(String s) throws Exception {
        char ch = 'a';
        StringBuffer sb = new StringBuffer(this.blocksize);
        int k = 0;
        while (k < this.blocksize) {
            sb.append(" ");
            ++k;
        }
        k = 0;
        while (k < this.keyword.length()) {
            if (this.alphabet.isInAlphabet(s.charAt(k))) {
                ch = this.cipherAlphabet.intToChar(this.alphabet.charToInt(s.charAt(k)));
                sb.setCharAt(this.keyword.charAt(k) - 48, ch);
            } else {
                sb.setCharAt(this.keyword.charAt(k) - 48, s.charAt(k));
            }
            ++k;
        }
        return sb.toString();
    }

    public String engineDecode(String s) throws Exception {
        char ch = 'a';
        if (s.length() < this.blocksize) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < this.blocksize) {
            sb.append(" ");
            ++k;
        }
        k = 0;
        while (k < this.invertedKeyword.length()) {
            if (this.alphabet.isInAlphabet(s.charAt(k))) {
                ch = this.alphabet.intToChar(this.cipherAlphabet.charToInt(s.charAt(k)));
                sb.setCharAt(this.invertedKeyword.charAt(k) - 48, ch);
            } else {
                sb.setCharAt(this.keyword.charAt(k) - 48, s.charAt(k));
            }
            ++k;
        }
        return sb.toString();
    }
}

