/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.HistoricalKey;

public class TranspositionKey
extends HistoricalKey {
    public static final String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "a series of positive integers";
    public static final String DEFAULT_KEYWORD_STRING = "2013";
    private String invertedKeyword;

    public void init(String keyspec) throws Exception {
        super.initKey(keyspec, true);
        this.blocksize = this.keyword.length();
        this.invertedKeyword = this.getInverseKey(this.keyword);
    }

    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception {
        if (alpha1 == null || alpha2 == null) {
            throw new Exception("TranspositionKey.init(): Null alphabet reference passed");
        }
        super.initKey(keyword, alpha1, alpha2);
        this.blocksize = keyword.length();
        this.invertedKeyword = this.getInverseKey(keyword);
    }

    public String getAlgorithm() {
        return "Transposition";
    }

    public String getInvertedKeyword() {
        return this.invertedKeyword;
    }

    private String getInverseKey(String s) {
        StringBuffer sb = new StringBuffer(this.blocksize);
        int k = 0;
        while (k < s.length()) {
            sb.append(" ");
            ++k;
        }
        k = 0;
        while (k < s.length()) {
            char ch = (char)(s.indexOf((char)(48 + k)) + 48);
            sb.setCharAt(k, ch);
            ++k;
        }
        return sb.toString();
    }
}

