/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.BlockCipher;
import hcrypto.cipher.HistoricalKey;
import hcrypto.engines.VigenereKey;

public class VigenereEngine
extends BlockCipher {
    protected String keyword;
    protected VigenereKey key;
    protected int keyPtr;

    public VigenereEngine() {
        this.alphabetRangeOptions = "111111/111111";
    }

    protected void engineInit(HistoricalKey hKey) throws Exception {
        if (!(hKey instanceof VigenereKey)) {
            throw new Exception("InvalidKey: Vigenere requires VigenereKey");
        }
        this.key = (VigenereKey)hKey;
        this.alphabet = this.key.getAlphabet();
        this.cipherAlphabet = this.key.getCTAlphabet();
        this.keyword = this.key.getKeyword();
        this.blocksize = this.key.getBlocksize();
        this.keyPtr = 0;
        this.printSquare();
    }

    public String engineEncode(String s) throws Exception {
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Vignere cipher " + this.blocksize);
        }
        char ch = s.charAt(0);
        if (this.alphabet.isInAlphabet(ch)) {
            char keyCh = this.keyword.charAt(this.keyPtr);
            char newCh = this.encodeShift(ch, this.alphabet.charToInt(keyCh));
            this.keyPtr = (this.keyPtr + 1) % this.keyword.length();
            return "" + newCh;
        }
        return s;
    }

    public String engineDecode(String s) throws Exception {
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Caesar cipher " + this.blocksize);
        }
        char ch = s.charAt(0);
        if (this.cipherAlphabet.isInAlphabet(ch)) {
            char keyCh = this.keyword.charAt(this.keyPtr);
            char newCh = this.decodeShift(ch, this.alphabet.getSize() - this.alphabet.charToInt(keyCh));
            this.keyPtr = (this.keyPtr + 1) % this.keyword.length();
            return "" + newCh;
        }
        return s;
    }

    protected void printSquare() {
        String primary = "abcdefghijklmnopqrstuvwxyz";
        int j = 0;
        while (j < 26) {
            int k = 0;
            while (k < primary.length()) {
                System.out.print(String.valueOf(primary.charAt((k + j) % primary.length())) + " ");
                ++k;
            }
            System.out.println();
            ++j;
        }
    }
}

