/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.engines;

import hcrypto.cipher.Alphabet;
import hcrypto.cipher.HistoricalKey;

public class VigenereKey
extends HistoricalKey {
    public static final String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "a keyword";
    public static final String DEFAULT_KEYWORD_STRING = "keyword";

    public void init(String keyspec) throws Exception {
        super.initKey(keyspec, false);
        if (!this.isValidKeyword(this.keyword)) {
            throw new Exception("Vigenere keyword contains invalid characters for selected alphabet");
        }
        this.blocksize = 1;
    }

    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception {
        if (alpha1 == null || alpha2 == null) {
            throw new Exception("VigenereKey.init(): Null alphabet reference passed");
        }
        this.keyword = keyword;
        super.initKey(keyword, alpha1, alpha2);
        if (!this.isValidKeyword(keyword)) {
            throw new Exception("Vigenere keyword contains invalid characters for selected alphabet");
        }
        this.blocksize = 1;
    }

    protected void initKeyArrays() throws Exception {
        if (this.alphabet.getSize() != this.cipherAlphabet.getSize()) {
            throw new Exception("ERROR: Plain and cipher alphabets must be the same size");
        }
        this.plainKey = new char[this.alphabet.getSize()];
        this.cipherKey = this.cipherAlphabet != this.alphabet ? new char[this.cipherAlphabet.getSize()] : new char[this.alphabet.getSize()];
        StringBuffer keychars = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
        int k = 0;
        while (k < keychars.length()) {
            char ch;
            this.cipherKey[k] = ch = keychars.charAt(k);
            this.plainKey[this.cipherAlphabet.charToInt((char)ch)] = this.alphabet.intToChar(k);
            ++k;
        }
    }

    public String getAlgorithm() {
        return "Vigenere";
    }

    private boolean isValidKeyword(String s) {
        int k = 0;
        while (k < s.length()) {
            if (!this.alphabet.isInAlphabet(s.charAt(k))) {
                return false;
            }
            ++k;
        }
        return true;
    }
}

