/*
 * Decompiled with CFR 0.152.
 */
package hcrypto.provider;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Provider {
    public static final String DELIMITER = ",";
    protected String name;
    private static Vector providers = new Vector();
    protected Hashtable spiTable = new Hashtable();
    protected Hashtable keyTable = new Hashtable();

    public Provider() {
    }

    public Provider(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void put(String cipherName, String engineClass, String keyClass) {
        this.spiTable.put(cipherName, engineClass);
        this.keyTable.put(cipherName, keyClass);
    }

    public String getCipherEngine(String algorithm) throws Exception {
        int k = 0;
        boolean found = false;
        String spi = null;
        while (k < providers.size() && !found) {
            Provider p = (Provider)providers.elementAt(k);
            if (p.spiTable.containsKey(algorithm)) {
                spi = (String)p.spiTable.get(algorithm);
                this.name = p.name;
                found = true;
                continue;
            }
            ++k;
        }
        if (!found) {
            throw new Exception("No such algorithm: " + algorithm);
        }
        return spi;
    }

    public String getCipherKeyName(String algorithm) throws Exception {
        int k = 0;
        boolean found = false;
        String key = null;
        while (k < providers.size() && !found) {
            Provider p = (Provider)providers.elementAt(k);
            if (p.keyTable.containsKey(algorithm)) {
                key = (String)p.keyTable.get(algorithm);
                this.name = p.name;
                found = true;
                continue;
            }
            ++k;
        }
        if (!found) {
            throw new Exception("No such algorithm: " + algorithm);
        }
        return key;
    }

    public String getCipherEngine(String algorithm, String provider) throws Exception {
        int k = 0;
        boolean found = false;
        String spi = null;
        while (k < providers.size() && !found) {
            Provider p = (Provider)providers.elementAt(k);
            if (p.getName().equals(provider)) {
                if (p.spiTable.containsKey(algorithm)) {
                    spi = (String)p.spiTable.get(algorithm);
                    this.name = p.name;
                    found = true;
                    continue;
                }
                throw new Exception("No engine for algorithm (" + algorithm + ") for provider " + provider);
            }
            ++k;
        }
        if (!found) {
            throw new Exception("No such provider: " + provider);
        }
        return spi;
    }

    public String getCipherKeyName(String algorithm, String provider) throws Exception {
        int k = 0;
        boolean found = false;
        String key = null;
        while (k < providers.size() && !found) {
            Provider p = (Provider)providers.elementAt(k);
            if (p.getName().equals(provider)) {
                if (p.keyTable.containsKey(algorithm)) {
                    key = (String)p.keyTable.get(algorithm);
                    this.name = p.name;
                    found = true;
                    continue;
                }
                throw new Exception("No key for algorithm (" + algorithm + ") for provider " + provider);
            }
            ++k;
        }
        if (!found) {
            throw new Exception("No such provider: " + provider);
        }
        return key;
    }

    public static void addProvider(Provider p) {
        providers.addElement(p);
    }

    public static void addCipher(String cipher, String provider, String spiName) {
        Provider p = new Provider(provider);
        providers.addElement(p);
        p.spiTable.put(cipher, spiName);
    }

    public static void addCipher(String cipher, String provider, String spiName, String keyName) {
        Provider p = new Provider(provider);
        providers.addElement(p);
        p.spiTable.put(cipher, spiName);
        p.keyTable.put(cipher, keyName);
    }

    public static String getCipherNames() {
        StringBuffer names = new StringBuffer();
        int j = 0;
        int k = 0;
        while (k < providers.size()) {
            Provider p = (Provider)providers.elementAt(k);
            Enumeration e = p.spiTable.keys();
            while (e.hasMoreElements()) {
                String algName = (String)e.nextElement();
                names.append(String.valueOf(algName) + " (" + p.getName() + ")" + DELIMITER);
                ++j;
            }
            ++k;
        }
        return names.toString();
    }
}

