/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import hcrypto.cipher.BlockCipher;
import hcrypto.cipher.HistoricalKey;
import plugins.CaesarKey;

public class CaesarEngine
extends BlockCipher {
    private int shift;
    private CaesarKey key;

    public CaesarEngine() {
        this.alphabetRangeOptions = "111111/111111";
    }

    protected void engineInit(HistoricalKey hKey) throws Exception {
        if (!(hKey instanceof CaesarKey)) {
            throw new Exception("InvalidKey: Caesar requires CaesarKey");
        }
        this.key = (CaesarKey)hKey;
        this.alphabet = this.key.getAlphabet();
        this.cipherAlphabet = this.key.getCTAlphabet();
        this.shift = this.key.getShift();
        this.blocksize = this.key.getBlocksize();
    }

    public String engineEncode(String s) throws Exception {
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Caesar cipher " + this.blocksize);
        }
        char ch = s.charAt(0);
        if (this.alphabet.isInAlphabet(ch)) {
            return "" + this.encodeShift(ch, this.shift);
        }
        return s;
    }

    public String engineDecode(String s) throws Exception {
        if (this.blocksize != 1) {
            throw new Exception("Invalid blocksize for Caesar cipher " + this.blocksize);
        }
        char ch = s.charAt(0);
        if (this.cipherAlphabet.isInAlphabet(ch)) {
            return "" + this.decodeShift(ch, this.cipherAlphabet.getSize() - this.shift);
        }
        return s;
    }
}

