/*
 * File: FileSaveMessageDialog.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * 
 * <P>Description: Implements a Java 1.1 version of a GUI tool for using and analyzing
 *  historical ciphers.

 * <P>Credits: This program is modelled after the ImageJ program which is written by
 *  Wayne Rasband of the National Institutes of Health. ImageJ is in the public domain.
 *

 * <P>Copyright: This program is in the public domain. You can modify it as you 
 *  see fit as long as you properly acknowledge its original authors (Morelli
 *  and Rasband). It would also be nice if you forwarded your changes to 
 *  <A HREF= "mailto:ralph.morelli@trincoll.edu">ralph.morelli@trincoll.edu</A> so 
 *  they can possibly be added to the "official" version.
 */
package cryptotoolj;

import java.awt.*;
import java.awt.event.*;

/**
 * This class implements a dialog window for the Save and SaveAs options.
 */ 

public class FileSaveMessageDialog extends Dialog implements ActionListener {
    public static final int CANCEL_OPTION = 0;  // Possible results
    public static final int NOSAVE_OPTION = 1;
    public static final int SAVE_OPTION = 2;
    public static final int WIDTH = 300;
    public static final int HEIGHT = 150;
    
    
    private Button saveButton, dontSaveButton, cancelButton;
    private Panel buttonPanel;
    private TextArea display;
    
    private int result = SAVE_OPTION;  // Default
    
    public FileSaveMessageDialog(Frame parent, String title) {
        super(parent, title, true);
        
        saveButton = new Button("Save");
        saveButton.addActionListener(this);
        dontSaveButton = new Button("Don't Save");
        dontSaveButton.addActionListener(this);
        cancelButton = new Button("Cancel");
        cancelButton.addActionListener(this);
        
        display = new TextArea("", 4, 50, TextArea.SCROLLBARS_NONE);
	display.setEditable(false);
        display.setText("Changes made to this text area will be  \n" +
                        "discarded if it is not saved. Do you want\n" +
                        "to save it before closing?");
        display.requestFocus();
    
        buttonPanel = new Panel();
        buttonPanel.add(dontSaveButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(saveButton);
        this.add(display,"North");
        this.add(buttonPanel, "Center");
        
        setSize(WIDTH, HEIGHT);
        Tools.centerWindow(this);
        setVisible(true);
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == cancelButton) 
            result = CANCEL_OPTION;
        else if (e.getSource() == dontSaveButton)
            result = NOSAVE_OPTION;
        else 
            result = SAVE_OPTION;
        setVisible(false);
    }
    
    public int getResult() { return result; }
}
