/**
 * File: KeyDialog.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * Description: Creates a dialog box for entering a cipher key and alphabet.
 * Credits: Revised from a Swing version of KeyDialog written by Gregg Marcuccio, Trinity '00
 *
 * Recent Modifications
 * 7/2002 -- R.Morelli: Extended functionality to handle two alphabets, one for plaintext
 *   and one for cryptotext
 */
package cryptotoolj;

import hcrypto.cipher.*;
import hcrypto.provider.*;
import hcrypto.engines.*;

import java.lang.*;    
import java.awt.*;
import java.awt.event.*;

/**  
 * Class <tt>KeyDialog</tt> is Dialog for entering a 
 * key value an alphabet range. These two selections are bundled into 
 * a String, which is used to construct a Cipher key.
 */
 
public class KeyDialog extends Dialog implements ItemListener {
    
    public static final int APPROVE_OPTION = 0;  // Possible results
    public static final int CANCEL_OPTION = 1;
    
    public static final int WIDTH = 500;
    public static final int HEIGHT = 400;
    
    private int option; // The dialog's result.
    
    private HistoricalKey key; //a reference to a "Key" Class                                            
    private String alphabet = "az";  //Stores a String which represents the user-chosen alphabet range.  Default == "az"
    private StringBuffer alphaBuffer = new StringBuffer();
    private String keyText = "";     //stores the keyText
    private Checkbox[] checkbox; //used for constructing certain alphabet JRadioButtons based on Cipher type. 
    private String plainAlphas;    // Coded string of 6 1s and 0s to represent possible alphabet choices
    private String cryptoAlphas; 
    //GUI components
    
    private Label keyLabel = new Label("Enter key: ");
    private Label plainLabel = new Label("Plaintext Alphabet: ");
    private Label cryptoLabel = new Label("Cryptotext Alphabet: ");
    private Label encodingLabel = new Label("File encoding: ");
    
    private Button OKButton, CancelButton;
    private Panel TextAreaPanel, ButtonPanel, keyAPanel, dialogPanel, 
	filePanel, alphabetPanel, alphabetPanel2;
//    private TextArea keyArea;
    private TextField keyArea;
    private TextField plainOther = new TextField(40);
    private TextField cryptoOther = new TextField(40);
    private TextField encodingField = new TextField("Default encoding");
    
    private Checkbox azB, AZB, otherB, azAZ09B, printableB, asciiB;
    private Checkbox azB2, AZB2, otherB2, azAZ09B2, printableB2, asciiB2;
    
    //Toolkit tools = Toolkit.getDefaultToolkit(); // tools.beep() //used for debugging
    
   /**
    * Creates a new instance of the KeyDialog class, with the specified cipher, keyName, and dialogTitle.
    * @param cipher a reference to the <a href="Cipher.html">Cipher</a> Class.
    * @param keyName a String representation of a particular "Key" Class name.  For Example: "CaesarKey".
    * @param dialogTitle a String representation of an appropriate title for the <tt>KeyDialog</tt>.
    */    
    public KeyDialog(Frame parent, String alphabets, String dialogTitle) {    //CONSTRUCTOR
        super(parent, true);  //"true" sets the JDialog as modal
//	System.out.println("Alphabetstr = " + alphabets);
        plainAlphas = alphabets.substring(0, alphabets.indexOf("/"));    // v1.3 e.g., 111001/111001  
        cryptoAlphas = alphabets.substring(alphabets.indexOf("/") +1);    // v1.3 e.g., 111001/111001  
//        System.out.println("Alphabets=" + plainAlphas + "/" + cryptoAlphas);
        this.setTitle(dialogTitle);                         
        this.createKeyDialog();
    }
    
   /**
    * Displays the KeyDialog and returns the option selected (0==APPROVE_OPION, 1==CANCEL_OPTION).
    */     
    public int showKeyDialog() {
        keyArea.setText(keyText); 
	setSize(WIDTH, HEIGHT);
	pack();
        setVisible(true);
        Tools.centerWindow(this);
        return this.option;
    }
    
   /**
    * Returns the alphabet choice selected with a <tt>JRadioButton</tt>.  Default selection is "az".
    */ 
    public String getSelectedAlphabetChoice() {
        return alphabet;
    }        
    
   /**
    * Returns the text in entered in the "key" <tt>JTextArea</tt>. 
    */    
    public String getKeyAreaText() {
        return keyArea.getText();
    }    
        
   /**
    * Sets the key <tt>JTextArea</tt> to the specified keytext.  
    * @param keyText A String representation of a key, usually used to display a default value
    * retrieved from a static constant in the "Key" class.
    */    
    public void setKeyText(String keyText) {
        this.keyText = keyText;
    }    
  
    private void createKeyDialog() { // creates various GUI components and assembles the final KeyDialog interface. 
        TextAreaPanel = new Panel(new BorderLayout());
        keyAPanel = new Panel();
        ButtonPanel = new Panel( );
        dialogPanel = new Panel(new BorderLayout() );
        Panel aPanels = new Panel(new GridLayout(2,1));
        alphabetPanel = new Panel();
        alphabetPanel2 = new Panel();
	filePanel = new Panel();
            
	filePanel.add(encodingLabel);
	filePanel.add(encodingField);
        OKButton = new Button("OK");
        CancelButton = new Button("Cancel");
    
//       keyArea = new TextArea(3, 40);
        keyArea = new TextField(40);

        checkbox = new Checkbox[12];        
        checkbox[0] = azB = new Checkbox("az");
        checkbox[1] = AZB = new Checkbox("AZ");
        checkbox[2] = azAZ09B = new Checkbox("09");
        checkbox[3] = printableB = new Checkbox("printable ASCII");
        checkbox[4] = asciiB = new Checkbox("All ASCII");
        checkbox[5] = otherB = new Checkbox("Other: Specify");
        checkbox[6] = azB2 = new Checkbox("az");
        checkbox[7] = AZB2 = new Checkbox("AZ");
        checkbox[8] = azAZ09B2 = new Checkbox("09");
        checkbox[9] = printableB2 = new Checkbox("printable ASCII");
        checkbox[10] = asciiB2 = new Checkbox("All ASCII");
        checkbox[11] = otherB2 = new Checkbox("Other: Specify");
        azB.setState(true);
        azB2.setState(true);
        
       this.setalphabets(plainAlphas, cryptoAlphas);

        keyAPanel.add(keyLabel);
        keyAPanel.add(keyArea);
        TextAreaPanel.add(keyAPanel, BorderLayout.NORTH);

        ButtonPanel.add(OKButton);
        ButtonPanel.add(CancelButton);
 
        dialogPanel.add(TextAreaPanel, BorderLayout.NORTH);
	aPanels.setLayout(new GridLayout(3,1));
        aPanels.add(alphabetPanel);
        aPanels.add(alphabetPanel2);
//	aPanels.add(filePanel);
        dialogPanel.add(aPanels, BorderLayout.CENTER);
        dialogPanel.add(ButtonPanel, BorderLayout.SOUTH);
 
        add(dialogPanel);       
         
        this.addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent evt) {
		option = CANCEL_OPTION;
                setVisible(false);
            } // windowClosing()

            public void windowOpened(WindowEvent evt) {
                CancelButton.requestFocus();
            } // windowOpened()
        });    //addWindowListener()
         
       /**
        * This actionPerformed method sets the option, alphabet, and keyText instance variables,
        * and sets the KeyDialog.setVisible(false) if length of text > 0 in text area.
       */     
        OKButton.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
		    if(keyArea.getText().length() > 0) {
	            	option = APPROVE_OPTION;

			alphaBuffer = new StringBuffer();
	            	if(azB.getState())
		              alphaBuffer.append("az+");
	            	if(AZB.getState())
		              alphaBuffer.append("AZ+");
	            	if(azAZ09B.getState())
		              alphaBuffer.append("09+");
	            	if(printableB.getState())
		              alphaBuffer.append("printable+");
	            	if(asciiB.getState())
		              alphaBuffer.append("ascii+");
		            
			if (!plainOther.getText().equals(""))
			    alphaBuffer.append(plainOther.getText() + "+");

//			alphaBuffer.append("/");
			alphaBuffer.setCharAt(alphaBuffer.length()-1, '/'); // Overwrite last '+'
                    
	            	if(azB2.getState())
		              alphaBuffer.append("az+");
	            	if(AZB2.getState())
		              alphaBuffer.append("AZ+");
	            	if(azAZ09B2.getState())
		              alphaBuffer.append("09+");
	            	if(printableB2.getState())
		              alphaBuffer.append("printable+");
	            	if(asciiB2.getState())
		              alphaBuffer.append("ascii+");  
			if (!cryptoOther.getText().equals(""))
			    alphaBuffer.append(cryptoOther.getText()+ "+");
		                          
//			alphaBuffer.deleteCharAt(alphaBuffer.length()-1); // Remove last '+'
			alphabet = alphaBuffer.toString().substring(0,alphaBuffer.length() - 1);

	    	    	keyText = keyArea.getText();  
	    	    	System.out.println("KeySpec: " + keyText + "/" + alphabet);
	            	setVisible(false);
          		}
        	} // actionPerformed()
        });    //okButton.addActionListener()
             
        CancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                option = CANCEL_OPTION;          
                setVisible(false);        
            } // actionPerformed()
        });    //okButton.addActionListener()
      
    }//end createKeyDialog()

    public void itemStateChanged (ItemEvent e) {
	Checkbox cb = (Checkbox)e.getSource();
	adjustCheckBoxes(cb);	
    }
	
    private void adjustCheckBoxes(Checkbox cb) {
	String label = cb.getLabel();
//	    System.out.println("adjustButtons: " + label + " " + cb.getState());
	if (cb == azB || cb == AZB || cb == azAZ09B) {
	    if (cb.getState() == true) {          // Button has been clicked on
		printableB.setState(false);          	
		asciiB.setState(false);
	    }
	}
	else if (cb == printableB) {
	    if (cb.getState() == true) {
		azB.setState(false);	
		AZB.setState(false);	
		azAZ09B.setState(false);	
		asciiB.setState(false);
	    }
	}	
	else if (cb == asciiB) {
	    if (cb.getState() == true) {
		azB.setState(false);	
		AZB.setState(false);	
		azAZ09B.setState(false);	
		printableB.setState(false);
	    }
	}
	if (cb == azB2 || cb == AZB2 || cb == azAZ09B2) {
	    if (cb.getState() == true) {          // Button has been clicked on
		printableB2.setState(false);          	
		asciiB2.setState(false);
	    }
	}
	else if (cb == printableB2) {
	    if (cb.getState() == true) {
		azB2.setState(false);	
		AZB2.setState(false);	
		azAZ09B2.setState(false);	
		asciiB2.setState(false);
	    }
	}	
	else if (cb == asciiB2) {
	    if (cb.getState() == true) {
		azB2.setState(false);	
		AZB2.setState(false);	
		azAZ09B2.setState(false);	
		printableB2.setState(false);
	    }
	}
	if (cb == otherB)
	    if (cb.getState() == true)
		plainOther.setText("EG: Range.ai+Range.kz+UnicodeBlock.GREEK");
	    else	
		plainOther.setText("");
	if (cb == otherB2)
	    if (cb.getState() == true)
		cryptoOther.setText("EG: Range.ai+Range.kz+UnicodeBlock.GREEK");
	    else	
		cryptoOther.setText("");
    }

    private void setalphabets(String plainAlphas, String cryptoAlphas) {
        alphabetPanel.add(plainLabel);
        for(int k=0; k < plainAlphas.length(); k++) {
            if(plainAlphas.charAt(k) == '1') 
              alphabetPanel.add(checkbox[k]); 
              checkbox[k].addItemListener(this);  
        }
        if (plainAlphas.charAt(plainAlphas.length()-1) == '1')
        	alphabetPanel.add(plainOther);
        alphabetPanel2.add(cryptoLabel);
        for(int k=0; k < cryptoAlphas.length(); k++) {
            if(cryptoAlphas.charAt(k) == '1') 
              alphabetPanel2.add(checkbox[plainAlphas.length() + k]); 
              checkbox[plainAlphas.length() + k].addItemListener(this);  
        }
        if (cryptoAlphas.charAt(cryptoAlphas.length()-1) == '1')
        	alphabetPanel2.add(cryptoOther);
    } // end setalphabets
}   //end KeyDialog Class
