/*
 * File: Menus.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * 
 * <P>Description: Implements the menu system for CryptoToolJ.

 * <P>Credits: This program is modelled after the ImageJ program which is written by
 *  Wayne Rasband of the National Institutes of Health. ImageJ is in the public domain.
 *
 * <P>Copyright: This program is in the public domain. You can modify it as you 
 *  see fit as long as you properly acknowledge its original authors (Morelli
 *  and Rasband). It would also be nice if you forwarded your changes to 
 *  <A HREF= "mailto:ralph.morelli@trincoll.edu">ralph.morelli@trincoll.edu</A> so 
 *  they can possibly be added to the "official" version.
 */
package cryptotoolj;

import hcrypto.cipher.*;
import hcrypto.provider.*;
import hcrypto.engines.*;

import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import java.io.File;
import java.applet.Applet;
import java.awt.event.*;

/**
 *  This class installs and updates CryptoToolJ's menus.
 */

public class Menus {

    private static final int STATIC_WINDOW_MENU_ITEMS = 2;
	
    private static MenuBar mbar;
    private static CryptoToolJ ctj;
    private static Applet applet;    
    
    public static Menu windowMenu;
    
    public Menus(CryptoToolJ ctg, Applet applet) {
        this.ctj = ctg;
        this.applet = applet;
    }
	
    public void addMenuBar() {
	Menu fileMenu = new Menu("File");
	addMenuItem(fileMenu, "New Cipher...", KeyEvent.VK_N, false);
	addMenuItem(fileMenu, "Open File...", KeyEvent.VK_O, false);
	addMenuItem(fileMenu, "Close Cipher...", KeyEvent.VK_W, false);
	fileMenu.addSeparator();
        addMenuItem(fileMenu, "Save", KeyEvent.VK_S, false);
        addMenuItem(fileMenu, "Save As", KeyEvent.VK_A, false);
        fileMenu.addSeparator();
        addMenuItem(fileMenu, "Print", KeyEvent.VK_P, false);
        fileMenu.addSeparator();
        addMenuItem(fileMenu, "Quit", KeyEvent.VK_Q, false);
        
        Menu editMenu = new Menu("Edit");
        addMenuItem(editMenu, "Cut", KeyEvent.VK_X, false);
        addMenuItem(editMenu, "Copy", KeyEvent.VK_C, false);
        addMenuItem(editMenu, "Paste", KeyEvent.VK_V, false);
        addMenuItem(editMenu, "Select All", 0, false);    
        
        windowMenu = new Menu("Window");
        CheckboxMenuItem item = new CheckboxMenuItem("CryptoToolJ");
        windowMenu.add(item);
        item.setState(true);
        item.addActionListener(ctj);    
        windowMenu.addSeparator();
		
        Menu helpMenu = new Menu("Help");
	addMenuItem(helpMenu, "About CryptoToolJ...", 0, false);
		
	mbar = new MenuBar();
	mbar.add(fileMenu);
	mbar.add(editMenu);
	mbar.add(windowMenu);
	mbar.add(createAnalysisMenu());	
    	mbar.setHelpMenu(helpMenu);
	ctj.setMenuBar(mbar);
    }
    
    private Menu createAnalysisMenu() {
        Menu analysisMenu = new Menu("Analysis");
//        addMenuItem(analysisMenu, "Get Statistics", 0, false);
        addMenuItem(analysisMenu, "Index Of Coincidence", KeyEvent.VK_I, false);
        addMenuItem(analysisMenu, "Text Analyzer", KeyEvent.VK_H, false);
        addMenuItem(analysisMenu, "English FAQ", KeyEvent.VK_Q, false);
        addMenuItem(analysisMenu, "Pattern Word Searcher", KeyEvent.VK_W, false);
        addMenuItem(analysisMenu, "Affine Analyzer", KeyEvent.VK_F, false);
        addMenuItem(analysisMenu, "Caesar Analyzer", KeyEvent.VK_R, false);
	//	if (applet == null)
	addMenuItem(analysisMenu, "Simple Substitution Analyzer", KeyEvent.VK_U, false);
        addMenuItem(analysisMenu, "Vigenere Analyzer", KeyEvent.VK_G, false);
        analysisMenu.addSeparator();
	if (applet == null)
	    addPluginAnalyzers(analysisMenu);                
        return analysisMenu;
    }
    
   /**
    * addPluginAnalyzers() gets the names of the classes in the analyzers 
    *  directory and adds them to the analyzer menu.
    */
    private void addPluginAnalyzers(Menu m) {
        String className="";
        try {
            File file = new File(Tools.getAnalyzerDirectory());
            String analyzers[] = file.list();
            if (analyzers != null) 
                for (int k = 0; k < analyzers.length; k++) {
                    className = analyzers[k];                // File name -- e.g., TextAnalyzer.class
                    
                    if (className.endsWith("Analyzer.class")) {
                        String menuName = className.substring(0, className.indexOf("."));
                        ctj.display.append("Adding plugin analyzer: " + menuName + "\n");
                        addMenuItem(m, menuName,0,false);
                    }
                }
            else {
                ctj.display.append("No analyzers found\n");
            }
		}
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    
    }

    void addMenuItem(Menu menu, String label, int shortcut, boolean shift) {
        MenuItem item;
	    if (shortcut==0)
            item = new MenuItem(label);
	    else {
             if (shift) {
                 item = new MenuItem(label, new MenuShortcut(shortcut, true));
		 //                 shortcuts.put(new Integer(shortcut+200),label);
              } else {
                 item = new MenuItem(label, new MenuShortcut(shortcut));
		 //                 shortcuts.put(new Integer(shortcut),label);
              }
        }
        item.setActionCommand(label);
        menu.add(item);
        item.addActionListener(ctj);
    }
	
    public static MenuBar getMenuBar() {
        return mbar;
    }

    public static void updateMenus() {
        CheckboxMenuItem item = null;  
        int nItems = windowMenu.getItemCount();  
        CipherFrame cf = WindowManager.getActiveCipherFrame();

        if (cf != null) {           // Mark one CipherFrame active                              
	        item = (CheckboxMenuItem)windowMenu.getItem(0);
	        item.setState(false);            
    	    for (int i= STATIC_WINDOW_MENU_ITEMS; i < nItems; i++) {
	            item = (CheckboxMenuItem)windowMenu.getItem(i) ;
	            item.setState( item.getLabel().indexOf(cf.getWindowId()) != -1);
            }
             return;
        }
                              // Mark CryptToolJ active
	    item = (CheckboxMenuItem)windowMenu.getItem(0);
	    item.setState(true);
    	for (int i= STATIC_WINDOW_MENU_ITEMS; i < nItems; i++) {
	        item = (CheckboxMenuItem)windowMenu.getItem(i);
            item.setState(false);
        }
         return;
    }

    public static void extendWindowMenu(String name) {
        if (ctj == null) return;
        CheckboxMenuItem item = new CheckboxMenuItem(name);
        item.addActionListener(ctj);  
        item.setState(true);
        windowMenu.add(item);
	    item = (CheckboxMenuItem)windowMenu.getItem(0);
	    item.setState(false);
    }

    public static void trimWindowMenu(String id) {
        for (int k = STATIC_WINDOW_MENU_ITEMS; k < windowMenu.getItemCount(); k++) {
            CheckboxMenuItem item = (CheckboxMenuItem)windowMenu.getItem(k);
            if (item.getLabel().indexOf(id) != -1) {
                windowMenu.remove(item);
                return;
            }
        }
        return;    
    }
		 
}// Menus
