/*
 * File: MessageDialog.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * 
 * <P>Description: Implements a modal message dialog for CryptoToolJ.

 * <P>Credits: This program is modelled after the ImageJ program which is written by
 *  Wayne Rasband of the National Institutes of Health. ImageJ is in the public domain.
 *
 * <P>Copyright: This program is in the public domain. You can modify it as you 
 *  see fit as long as you properly acknowledge its original authors (Morelli
 *  and Rasband). It would also be nice if you forwarded your changes to 
 *  <A HREF= "mailto:ralph.morelli@trincoll.edu">ralph.morelli@trincoll.edu</A> so 
 *  they can possibly be added to the "official" version.
 */
package cryptotoolj;

import java.awt.*;
import java.awt.event.*;

/** 
  This class implements a modal dialog box that displays information. 
  Based on the 	InfoDialogclass from "Java in a Nutshell" by David Flanagan. 
*/
public class MessageDialog extends Dialog implements ActionListener {
    protected Button button;
    protected MultiLineLabel label;
//    protected Label label;

    public MessageDialog(Frame parent, String title, String message) {
        super(parent, title, true);
        setLayout(new BorderLayout());
        if (message==null) message = "";
	    label = new MultiLineLabel(message);
//	    label = new Label(message);
		label.setFont(new Font("Dialog", Font.PLAIN, 12));
        add("Center", label);
        button = new Button("  OK  ");
		button.addActionListener(this);
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        p.add(button);
        add("South", p);
        pack();
//		GUI.center(this);
        show();
    }
    

	public void actionPerformed(ActionEvent e) {
		setVisible(false);
		dispose();
	}

}
