/*
 * File: ProviderTest.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * 
 * <P>Description: Tests the provider interface for CryptoToolJ.
 *
 * <P>Copyright: This program is in the public domain. You can modify it as you 
 *  see fit as long as you properly acknowledge its original authors (Morelli
 *  and Rasband). It would also be nice if you forwarded your changes to 
 *  <A HREF= "mailto:ralph.morelli@trincoll.edu">ralph.morelli@trincoll.edu</A> so 
 *  they can possibly be added to the "official" version.
 */
package cryptotoolj;

import hcrypto.cipher.*;
import hcrypto.provider.*;
import hcrypto.engines.*;

import java.io.*;

/**
 *  This class conducts a simple test of the Provider interface.
 */

public class ProviderTest {

    public ProviderTest () {

        Provider.addProvider(new DefaultProvider("Default")); 
        Provider.addProvider(new RamProvider("Ram"));
        
        String directory = "plugins"; // ".";
        String prefix = "plugins.";        
        String cipherName = "";
        String spiName = "";

        try {
        File file = new File(directory);
        String plugins[] = file.list();
        if (plugins != null) {
            for (int k = 0; k < plugins.length; k++) {
                String className = plugins[k];
                if (className.endsWith("CipherSpi.class")) {
                    System.out.println("Found class: " + className);
		    spiName = prefix + className.substring(0, className.indexOf("."));
                    cipherName = className.substring(0, className.indexOf("CipherSpi"));
                    System.out.println("Creating a new cipher " + cipherName);
		    //		    Class paramtypes[] = { Class.forName("java.lang.String") };
		    //		    java.lang.reflect.Constructor constr = Class.forName(className).getConstructor(paramtypes);
		    //                    Object constargs[] = { new String("Plugin" + k) };
		    Provider.addCipher(cipherName, "Plugin" + k, spiName);
		    //                    Provider.addProvider((Provider)constr.newInstance(constargs));
                }
            }
        }
        else 
            System.out.println("No plugins found");
        } catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        
        System.out.println(Provider.getCipherNames());
    }

    public static void main(String args[]) {  //main method
        ProviderTest pt = new ProviderTest(); 
    }  //end main()
}
