/*
 * File: TextManager.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * 
 * <P>Description: Manages the cut/paste operations for a TextArea.

 * <P>Credits: This program is modelled after the ImageJ program which is written by
 *  Wayne Rasband of the National Institutes of Health. ImageJ is in the public domain.
 *
 * <P>Copyright: This program is in the public domain. You can modify it as you 
 *  see fit as long as you properly acknowledge its original authors (Morelli
 *  and Rasband). It would also be nice if you forwarded your changes to 
 *  <A HREF= "mailto:ralph.morelli@trincoll.edu">ralph.morelli@trincoll.edu</A> so 
 *  they can possibly be added to the "official" version.
 */
package cryptotoolj;

import java.awt.*;
import java.awt.datatransfer.*;

/** 
 * This class manages the cutting, pasting, copying of text for all windows 
 */
public class TextManager implements ClipboardOwner {

    private static String appletClip = null;

    public static void copyText(boolean cut) {
    	CipherFrame cf = (CipherFrame)WindowManager.getActiveCipherFrame();
        CryptoToolJ ctj = WindowManager.getCryptoTool();
    	
    	TextArea tf = null;
    	String selection = null;
    	if (cf != null) {    	    
            tf = cf.getTextAreaWithFocus();
            if (tf == null) 
                return;
        }
        else if (cut) {     // Don't cut text from CryptoToolJ     
            ctj.showStatus("Cuts not allowed in CryptoToolJ");
            return;
        }
        else {
            boolean isActiveWindow = ctj.getFocusOwner()!=null;
            if (!isActiveWindow) {
                ctj.showStatus("CTJ not in focus");
                return;
            }
            tf = ctj.display;
        }

        if (!ctj.isApplet()) {
            Clipboard clip = ctj.getToolkit().getSystemClipboard();
            if (clip==null) {
                ctj.showStatus("Clipboard null");            
                return;
            }
            selection = tf.getSelectedText();
            StringSelection cont = new StringSelection(selection);
            clip.setContents(cont, ctj);
        }
        else {
            selection = tf.getSelectedText();
            appletClip = tf.getSelectedText();
        }
        if (selection.length() > 0) {
            ctj.showStatus(selection.length() + " characters copied to clipboard");
        }
        if (cut) 
            tf.replaceRange("", tf.getSelectionStart(), tf.getSelectionEnd());
    }
        
    public static void pasteText() {
    	CipherFrame cf = (CipherFrame)WindowManager.getActiveCipherFrame();
        CryptoToolJ ctj = WindowManager.getCryptoTool();
        String text;
        TextArea tf = null; 
        if (cf != null)
            tf = cf.getTextAreaWithFocus();
        else
            tf = ctj.display;
        if (tf == null) return;
 
        if (!ctj.isApplet()) {
            Clipboard clip = ctj.getToolkit().getSystemClipboard();
            if (clip==null) return;
            Transferable contents = clip.getContents(ctj);
            try {
 	        text = (String)(contents.getTransferData(DataFlavor.stringFlavor));
                tf.replaceRange(text, tf.getSelectionStart(), tf.getSelectionEnd());
            } 
            catch (Exception e) {}
        }
        else {
            if (appletClip == null) return;
            text = appletClip;
            tf.replaceRange(text, tf.getSelectionStart(), tf.getSelectionEnd());
        }
    }

    public static void selectAll() {
        TextArea tf = null;
    	CipherFrame cf = (CipherFrame)WindowManager.getActiveCipherFrame();
        CryptoToolJ ctj = WindowManager.getCryptoTool();
        if (cf != null)
            tf = cf.getTextAreaWithFocus();
        else
            tf = ctj.display;
        if (tf == null) return;
        tf.selectAll();
    }

    public void lostOwnership (Clipboard clip, Transferable cont) {}


}
