/*
 * File: Tools.java
 * Description: A collection of static utility methods.
 */

package cryptotoolj;

import java.awt.*;

public class Tools {

    public static void centerWindow( Window win) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winSize = win.getSize();
        int x = (screenSize.width - winSize.width)/2;
        int y = (screenSize.height - winSize.height)/4;
        if (y < 0) 
            y = 0;
        win.setLocation(x, y);    
    }

    public static String getProviderDirectory() {
        if (System.getProperty("os.name").equals("Mac OS"))
            return "Java Classes" + System.getProperty("file.separator") + "providers";
        else
	    return System.getProperty("user.dir") + System.getProperty("file.separator") + "providers";
//            return "." +  System.getProperty("file.separator") + "providers";    
    }
    
    public static String getPluginDirectory() {
        if (System.getProperty("os.name").equals("Mac OS"))
            return "Java Classes" + System.getProperty("file.separator") + "plugins";
        else
	    return System.getProperty("user.dir") + System.getProperty("file.separator") + "plugins";
//            return "." +  System.getProperty("file.separator") + "plugins";        
    }

    public static String getProviderPackageName() {
        return "providers";
    }

    public static String getAnalyzerPackageName() {
        return "analyzers";
    }
    
    public static String getAnalyzerDirectory() {
        if (System.getProperty("os.name").equals("Mac OS"))
            return "Java Classes" + System.getProperty("file.separator") + "analyzers";
        else
	    return System.getProperty("user.dir") + System.getProperty("file.separator") + "analyzers";
    }

}
