/*
 * File: WindowManager.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * 
 * <P>Description: Manages all window operations.

 * <P>Credits: This program is modelled after the ImageJ program which is written by
 *  Wayne Rasband of the National Institutes of Health. ImageJ is in the public domain.
 *
 * <P>Copyright: This program is in the public domain. You can modify it as you 
 *  see fit as long as you properly acknowledge its original authors (Morelli
 *  and Rasband). It would also be nice if you forwarded your changes to 
 *  <A HREF= "mailto:ralph.morelli@trincoll.edu">ralph.morelli@trincoll.edu</A> so 
 *  they can possibly be added to the "official" version.
 */
package cryptotoolj;


import java.awt.*;
import java.util.*;

/** 
 * This class consists of static methods used to manage CryptoTool windows. 
 */
public class WindowManager {

    private static Vector windowList = new Vector();
    private static int id = 1001;
    private static CryptoToolJ ctj;
    private static java.applet.Applet applet;
	
    public static void init(CryptoToolJ cryptotool, java.applet.Applet appletIn) {
	ctj = cryptotool;
	applet = appletIn;	
    }

    public static CryptoToolJ getCryptoTool() {
        return ctj;
    }
    
    public static java.applet.Applet getApplet() {
        return applet;
    }

    public static CipherFrame getActiveCipherFrame() {
	for (int k = 0; k < windowList.size(); k++) {
	    CipherFrame cf = (CipherFrame) windowList.elementAt(k);
	    if (cf.isActivated) {
		return cf;
	    }
	}
	return null;
    }	

    public static int getWindowCount() {
	return windowList.size();
    }

    public synchronized static void addWindow(CipherFrame win) {
	windowList.addElement(win);
	win.setWindowId(id);
	String idStr = "" + id;
	id++;
        Menus.extendWindowMenu("CipherFrame " + idStr);
        win.renameWithWindowId(idStr);
    }


    /** Closes the current window and removes it from the window list. */
    public synchronized static void removeWindow(CipherFrame win) {
	int index = windowList.indexOf(win);
	if (index == -1)
	    return;  // not on the window list
	Menus.trimWindowMenu(win.getWindowId());
	windowList.removeElementAt(index);
    }

    /** Closes all CipherFrame windows. Stops and returns false if any "save changes" dialog is canceled. */
    public synchronized static boolean closeAllWindows() {
	for (int k = 0; k < windowList.size(); k++) {
	    CipherFrame cf = (CipherFrame)windowList.elementAt(k);
	    if (!cf.close())
		return false;
	}
	return true;
    }

    /** Activates a window selected from the Window menu. */
    synchronized static void activateWindow(String menuItemLabel) {
	for (int i=0; i < windowList.size(); i++) {
	    CipherFrame win = (CipherFrame)windowList.elementAt(i);
	    String id = win.getWindowId();
	    if (menuItemLabel.indexOf(id) != -1) {
		win.activate();
		break;
	    }
	}
    }
        
}








