import hcrypto.cipher.*;
import hcrypto.provider.*;

import java.io.*;

public class CryptoFileMaker {

    private int[] primes = {2,3,5,7,11,13,17,23};    
    private String shiftKeyword = "";

   /*  *****Added by REW 7/14/2003
       Create random substitution cipher.
   */
   public String randomizeSub(String inText, Alphabet alph,
          int[] substitution, int maxChanged){

       int j, k, temp;  //used for loops and swap

       for ( j = 0; j < maxChanged; j++){
           k = (int)(Math.random()*maxChanged);
           temp = substitution[j];
           substitution[j] = substitution[k];
           substitution[k] = temp;
       }//for
        StringBuffer outText = new StringBuffer();
        try{
            for ( j = 0; j < inText.length(); j++){
                temp = alph.charToInt(inText.charAt(j));
                outText.append(alph.intToChar(substitution[temp]));
            }//for
        }//try
        catch(Exception exc){
            System.out.println(exc.toString());
        } //catch
        return outText.toString();
   }//randSubstitute

    public String randomAlberti(String inText, int[] substitution, int maxChanged){
	int temp;  //used for loops and swap

	for (int j = 0; j < maxChanged; j++){       // Randomize permutation alphabet
	    int k = (int)(Math.random()*maxChanged);
	    temp = substitution[j];
	    substitution[j] = substitution[k];
	    substitution[k] = temp;
	}//for

	StringBuffer permKeyBuffer = new StringBuffer();
	for (int k = 0; k < 26; k++) {      // Alberti uses 26 letter alphabet
            permKeyBuffer.append((char)('a' + substitution[k]));
	}
	String permKey = permKeyBuffer.toString();

	int shiftKeyLen = primes[(int)(Math.random() * primes.length)]; // Random shift key length
	//	int shiftKeyLen = primes[(int)(Math.random() * 4)]; // Random shift key length
	StringBuffer shiftKeyBuffer = new StringBuffer();
	for (int k = 0; k < shiftKeyLen; k++) {
	    shiftKeyBuffer.append( (char)('a' + (int)(Math.random() * 26)));
	}
	String shiftKey = shiftKeyBuffer.toString();    // Create the shift key
	shiftKeyword = shiftKey +"(" + shiftKeyLen +")";
	String keyspec = permKey + "," + shiftKey + "/az";
	System.out.println("keyspec = " + keyspec);
        Provider.addProvider(new DefaultProvider("Default"));    // Create and register the provider classes
        Provider.addProvider(new RamProvider("Ram")); 
	String encryptStr="";
	try {
	    Cipher cipher = Cipher.getInstance("Alberti");   // Create an instance of the cipher and its corresponding key
	    HistoricalKey key = HistoricalKey.getInstance(cipher.getAlgorithm(), cipher.getProvider());
	    key.init(keyspec);        // Initialize the key using the keyspec
	    cipher.init(key);          // Get and use individual ciphers
	    encryptStr = cipher.encrypt(inText);
	} catch (Exception e) {
	}
        return encryptStr;
   }//randomAlberti

   public String singleSpaces(String inText){

        char thisChar, lastChar;
        StringBuffer outText = new StringBuffer();
        lastChar = inText.charAt(0);
        outText.append(lastChar);
        for ( int j = 1; j < inText.length()-1; j++){
            thisChar = inText.charAt(j);
            if (!((thisChar == ' ') && (lastChar == ' ')) ){
              outText.append(thisChar);
              lastChar = thisChar;
            }//if
        }//for
        return outText.toString();
   }//singleSpaces()

 /* writeCiphertextFiles() creates a collection of files in a directory named
 outRootName+"dir". There are numEachSize different files for each of a
 collection of different sizes. The different sizes start at minMessSize and
 the size is increased by gapMessSize repeatedly up to the largest such
 size which is less than or equal to maxMessSize. The size of the file is
 is determined by counting the non-space characters.  Additional characters
 are added to complete the last word. Each file consists of a cryptogram on
 one line, "$$$" on the next line and the plaintext on a third line.
 */
  public void writeCiphertextFiles(String sourceFile, String outRootName,
      int minMessSize, int gapMessSize, int maxMessSize, int numEachSize, Alphabet alph){

      try{
          StringBuffer pText = new StringBuffer(); //the palintext message
          String pString; //Will store the cleaned up version of pText
          String cText; //the ciphertext message
          String line = null;
          int len = 0; // will store the length of line.
          int pos = 0; // position of char in line
          char ch; // Will point to char read from file.
          int chNum = 0; // Will count the number of acceptable chars.

          boolean done = false;
          boolean messDone = false;
          FileWriter outStream;
          File outDir = new File(outRootName + "dir");
          if (outDir.mkdir())  System.out.println("Directory " + outRootName + "dir created");
          else System.out.println("Directory " + outRootName + "dir either already exists or failed");
          File outFile; //Used to reference files created.
          BufferedReader inStream = new BufferedReader(new FileReader(sourceFile));
          System.out.println("sourceFile= " + sourceFile + " opened");
          int curMessSize =  minMessSize;
          int curMessNum = 0;
          int lineCount = (int)(Math.random()*50);
          int[] substitution = new int[alph.getSize()];
          for (int j = 0; j < alph.getSize(); j++){
             substitution[j] = j;
          }//for

          while (!done){
              line = inStream.readLine();
              if(line == null){   // If eof then close and reopen
                  inStream.close();
                  inStream = new BufferedReader(new FileReader(sourceFile));
                  System.out.println("sourceFile= " + sourceFile + " opened");
                  line = inStream.readLine();
                  //if there still is no line throw exception
                  if (line == null) {
                      throw new Exception("Bad source file in TextUtilities.writeCiphertextFiles()");
                  }//if
              }//if
              lineCount--;
              len = line.length();
              if ((len > 0)&&(lineCount < 0)){
                  line = line.toLowerCase();
                  pos = 0;
                  while ((pos < len) && !messDone){
                      ch  = line.charAt(pos);
                      if (alph.isInAlphabet(ch)){
                            chNum++;
                            pText.append(ch);
                      }//if  ch is in alphabet
                      else{ //if not in the alphabet it still might separate words
                           if (ch != '\'') pText.append(' ');
                      }//else
                      if ( (chNum >= curMessSize) && ((ch ==' ') || (ch == '\n')) ){
                          messDone = true;
                          outFile = new File(outDir, outRootName+curMessSize+"_"+curMessNum+".txt");
                          outStream = new FileWriter(outFile);
                          pString = singleSpaces(pText.toString());
			  cText = randomAlberti(pString,substitution,26);
			  //                          cText = randomizeSub(pString,alph,substitution,26);
                          outStream.write(cText);
                          outStream.write("\n$$$\n");
                          outStream.write(pString);
                          outStream.write("\n#"+shiftKeyword+"#\n");
                          outStream.close();
                      }//if message is long enough
                      pos++;
                      if ((pos == len) && (messDone == false))  pText.append(' ');
                  }//while pos in line
              }//if a useable line
              if (messDone){ // reset variables before reading next line
                  messDone = false;
                  pText = new StringBuffer();
                  chNum = 0;
                  lineCount = (int)(Math.random()*50);
                  curMessNum++;
                  if (curMessNum >= numEachSize){
                      curMessNum = 0;
                      curMessSize += gapMessSize;
                  }//if
                  if (curMessSize > maxMessSize){
                      done = true;
                  }//if
              } //if message wasdone
              line = inStream.readLine();

           } //while not done
           // textSize  = chNum;
           System.out.println("Finished writing Files." );

            inStream.close();
        }//try
        catch(Exception exc){
            System.out.println("In TextUtilities.writeCiphertextFiles() - " +exc.toString());
	           exc.printStackTrace();
        } //catch
  }//writeCiphertextFiles

    public static void main(String[] args){
	if (args.length < 6) {
	    System.out.println("Usage: java CryptoFileMaker bookfile filenameroot low incr high number");
	    return;
	}
	
	CryptoFileMaker maker = new CryptoFileMaker();
	try{
	    char[] arr = {'a','z',' ',' '};
	    Alphabet alph = new Alphabet(arr);
	    //	    maker.writeCiphertextFiles("oliver.txt","oliver",25,25,125,20,alph);
	    maker.writeCiphertextFiles(args[0],args[1],Integer.parseInt(args[2]),
				       Integer.parseInt(args[3]),
				       Integer.parseInt(args[4]),
				       Integer.parseInt(args[5]),alph);
	}  //try
	catch(Exception exc){
	    System.out.println(exc.toString());
	} //catch
    }//main()
} // CryptoFileMaker
