/*
 *  File: FileCipher.java
 *  Written: August, 2000
 *  Author: Ralph Morelli
 *
 * Copyright: This program is in the public domain. You can modify it as you 
 *  see fit as long as you properly acknowledge its original author (Morelli).
 *  It would also be nice if you forwarded your changes to 
 *  <A HREF= "mailto:ralph.morelli@trincoll.edu">ralph.morelli@trincoll.edu</A> so 
 *  they can possibly be added to the "official" version.
 *
 *  Description: This command-line program can be used to test the
 *   installation of the HcryptoJ API. The following example command
 *   lines show how to compile and run the program.  It assumes that 
 *   the hcrypto.jar file is located 2 directory levels above the directory 
 *   containing this program, which is the default hierarchy of HcryptoJ.
 *
 *   In the following example, a Caesar cipher with a shift of 4 and an
 *   alphabet of 'a' to 'z' is being used to encrypt or decrypt
 *   the infile producing the outfile as a result.
 *
 *  To compile: javac -classpath ../../hcrypto.jar:. FileCipher.java
 *  To run:     java -classpath ../../hcrypto.jar:. FileCipher Caesar \
 *            4/az/az -e|-d infile outfile [encoding]
 *
 * MODIFICATION v1.3: 
 *  HcryptoJ can specify different alphabets for the 
 *  input and output message. This requires a revised key specification.
 *  The second alphabet is optional. So the following specification for
 *  a Caesar cipher is still valid: 4/az. But the following specifications
 *  are also valid:
 *     Caesar 4/az/az
 *     Caesar 4/az+AZ/az+AZ 
 *     Caesar 4/printable+UnicodeBlock.HIRAGANA/printable+UnicodeBlock.HIRAGANA
 *  For details on the allowable specifications, see AlphabetFactory.java.
 *
 * MODIFICATION v1.3:
 * This program has been modified to accept files with
 *  alternative Unicode 1.1 encodings. These can be specified by the
 *  optional command-line encoding parameter. An example would be
 *  the file testfiles/iso-2022-jp, which uses an ISO-2022-JP encoding.
 * 
 * FileCipher can encrypt the Hiragana characters in this file by using
 *  the following command line:
 *
 * java -classpath ../../classes:. FileCipher Caesar \
 *       4/UnicodeBlock.HIRAGANA/UnicodeBlock.HIRAGANA -e \
 *       testfile etestfile ISO-2022-JP
 *  
 * FileCipher can encrypt the printable ascii and the Hiragana characters
 *  using the following command line:
 * 
 *  java -classpath ../../classes:. FileCipher Caesar \
 *    1/printable+UnicodeBlock.HIRAGANA/printable+UnicodeBlock.HIRAGANA -e iso-2022-jp  \
 *    iso-2022-jp.enc ISO-2022-JP    

 * The program CreateUnicodeFile.java enables you to create a small file that uses
 *  ISO-2022-JP encoding. Here's an example of how it can be used:
 *
 * $ java CreateUnicodeFile  // creates a ISO-2022-JP file called testfile
 * $ java -classpath ../../classes:. FileCipher Caesar \
 *    1/UnicodeBlock.HIRAGANA/UnicodeBlock.HIRAGANA -e testfile etestfile \
 *    ISO-2022-JP
 * $ java -classpath ../../classes:. FileCipher Caesar \
 *    1/UnicodeBlock.HIRAGANA/UnicodeBlock.HIRAGANA -d etestfile detestfile \
 *    ISO-2022-JP
 * 
 * The files testfile and detestfile should be equivalent.
 * 
 */

import hcrypto.cipher.*;
import hcrypto.provider.*;
import hcrypto.engines.*;
import java.io.*;

public class FileCipher {
   
    public static void main (String args[]) throws Exception {
        if (args.length < 5) {
            System.out.println("Usage: java FileCipher cipher keyspec -e|-d infile outfile [encoding]");
            return;
        }
        System.out.println("Encoding=" + System.getProperty("file.encoding"));

        // Create and register the provider classes
        Provider.addProvider(new DefaultProvider("Default")); 
        Provider.addProvider(new RamProvider("Ram")); 

        // Get the command line arguments and construct the key name

        String cipherName = args[0];
        String keyspec = args[1];
 
        // Create an instance of the cipher and its corresponding key

        Cipher cipher = Cipher.getInstance(cipherName);
        HistoricalKey key = HistoricalKey.getInstance(cipher.getAlgorithm(), cipher.getProvider());

        // Initialize the key using the keyspec
        key.init(keyspec);

        // Get and use individual ciphers
        cipher.init(key);
        System.out.println("Algorithm = " + cipher.getAlgorithm());
        System.out.println("Provider = " + cipher.getProvider());
        
        if (args[2].indexOf("e") != -1)
            if (args.length == 6)
                cipher.encryptFile(args[3], args[4], args[5]);
            else
                cipher.encryptFile(args[3], args[4]);
        else
            if (args.length == 6)
                cipher.decryptFile(args[3], args[4], args[5]);
            else
                cipher.decryptFile(args[3], args[4]);

//	IC ic = new IC();
	File oFile = new File(args[4]);
	InputStreamReader iStream = new InputStreamReader(new FileInputStream(oFile));
	int length = (int)oFile.length();            // Read the data
	char[] input = new char[length];
	iStream.read(input);
	iStream.close();
	String inString = new String(input);
	//	System.out.println("IC= " + ic.calculate(inString));
    }
}

