/*
 *  File: ICTester.java
 *  Written: December 2004
 *  Author: Ralph Morelli
 *
 * Copyright: This program is in the public domain. You can modify it as you 
 *  see fit as long as you properly acknowledge its original author (Morelli).
 *  It would also be nice if you forwarded your changes to 
 *  <A HREF= "mailto:ralph.morelli@trincoll.edu">ralph.morelli@trincoll.edu</A> so 
 *  they can possibly be added to the "official" version.
 *
 */

import hcrypto.cipher.*;
import hcrypto.provider.*;
import hcrypto.engines.*;
import hcrypto.analyzer.*;
import java.io.*;

public class ICTester {
    private static final int N_TRIALS = 50;

    public static void main (String args[]) throws Exception {
	
        if (args.length < 1) {
            System.out.println("Usage: java ICTester filename");
            return;
        }

	IC ic = new IC();
	IndexOfCoincidence ioc;
	File oFile = new File(args[0]);
	InputStreamReader iStream = new InputStreamReader(new FileInputStream(oFile));
	int length = (int)oFile.length();            // Read the data
	char[] input = new char[length];
	iStream.read(input);
	iStream.close();
	String inString = new String(input);
	System.out.println("IC= " + ic.calculate(inString.toLowerCase()));
	ioc = new IndexOfCoincidence(inString.toLowerCase());
	double true_ic = ioc.getIOC();
	System.out.println("IOC= " + true_ic);

	java.text.NumberFormat nf = java.text.NumberFormat.getInstance();
	nf.setMaximumFractionDigits(6);
	double x[] = new double[N_TRIALS];
	for (int len = 10; len <= 10000; len += 100) {
	    double avg_ioc = 0;
	    for (int k = 0; k < N_TRIALS; k++) {
		int start = (int)(Math.random() * (length-len-1));
		String s = inString.substring(start, start + len);
		//		String s = inString.substring(0, len);
		ioc = new IndexOfCoincidence(s);
		avg_ioc += (x[k] = ioc.getIOC());
	    }
	    double mean = avg_ioc/N_TRIALS;
	    double variance = 0;
	    for (int k = 0; k < N_TRIALS; k++) 
		variance += (x[k] - mean) * (x[k] - mean);
	    System.out.println("N= " + len + "\tIOC mean= " + nf.format(mean) + "\tVar= " + nf.format(variance/N_TRIALS) + "\tStdDev= " + nf.format(Math.sqrt(variance/N_TRIALS))
			       + "\tabsDiff= " + Math.abs(true_ic-mean));
	}
    }
}

