/**
 * TestAnalyzer.java tests any executable analyzer -- that is, any class
 *  that implements the hcrypto.Analyzer interface. Such classes are
 *  located in either of two directories:

 *      ../../source/hcrypto/analyzer  -- Part of the hcrypto package
 *      ../../classes/hcrypto/analyzer
 *
 *      ../../source/analyzers/ -- Plugin analyzers
 *      ../../classes/analyzers/ -- Plugin analyzers
 *
 *
 * To compile and run this program you need to specify the complete name of
 *  the analyzer -- e.g., hcrypto.analyzer.CaesarAnalyzer  or analyzers.NullAnalyzer.
 *
 *  To compile: javac -classpath ramcrypto.jar:. TestAnalyzer.java
 *  To run:     java -classpath ramcrypto.jar:. TestAnalyzer analyzerclass cryptotext
 *  Examples:   java -classpath ramcrypto.jar:. TestAnalyzer hcrypto.analyzer.IndexOfCoincidence cryptotext
 *          :   java -classpath ramcrypto.jar:. TestAnalyzer hcrypto.analyzer.DigramAnalyzer cryptotext
 *          :   java -classpath ramcrypto.jar:. TestAnalyzer hcrypto.analyzer.CaesarAnalyzer cryptotext
 *          :   java -classpath ramcrypto.jar:. TestAnalyzer analyzers.NullAnalyzer cryptotext
 *          :   java -classpath ramcrypto.jar:. TestAnalyzer analyzers.TestAnalyzer cryptotext
 */

import hcrypto.analyzer.*;
import hcrypto.cipher.*;
import hcrypto.provider.*;
import hcrypto.engines.*;

import analyzers.*;   // Plugin analyzers

import java.io.*;

public class TestAnalyzer {
   
    public static void main (String args[]) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: java TestAnalyzer package.analyzer infile  [encoding]");
            System.out.println("Example: java TestAnalyzer hcrypto.analyzer.CaesarAnalyzer caesar.txt");
            System.out.println("Example: java TestAnalyzer analyzers.TestAnalyzer caesar.txt");
            System.out.println("See the classes/hcrypto/analyzer directory for names.");
            System.out.println("See the classes/analyzers and classes/hcrypto/analyzer directories.");
            return;
        }
	String classname = args[0];
        File file = new File(args[1]);
        InputStreamReader inStream;

        if (args.length==3)
   	    inStream = new InputStreamReader(new FileInputStream(file), args[2]);
        else
   	    inStream = new InputStreamReader(new FileInputStream(file));
	int length = (int)file.length();            // Read the data
	char[] input = new char[length];
	inStream.read(input);
	inStream.close();

        System.out.println("Loading " + classname + " class");
        String text = new String(input);

	//        Analyzer analyzer = (Analyzer)Class.forName("hcrypto.analyzer." + classname).newInstance();
        Analyzer analyzer = (Analyzer)Class.forName(classname).newInstance();
        analyzer.setup(text);
        analyzer.run();
        System.out.println(analyzer.getReport());
    }

}

