#!/bin/bash

# a script to process the results of alberti run files

# Usage: ./analsumalberti 'regExpr in quotes'
# Example ./analsumalberti 'ga_runs/*run*'

if [ $# -ne 1 ]
    then 
    echo "Usage: ./analsumalberti.sh 'regexp in quotes'"
    echo "Example: ./analsumalberti.sh 'ga_runs/*run*'"
    exit 2
    fi

#echo $1

awk '
        BEGIN {
#	    print "RUN\tWRONG\tNGAM";
#	    print "NUM\tCHARS\tEVAL";
	}
               
        /^EXPERIMENT:/ {
	    EPSILON = 0
	    n += 1
	    size = $4
	    ic = $6
	    p = $8
	    sizeDivP = size/p
	    val = 0
	}
        /^ANALYZER:/ {
	    val = substr($16, 7, length($16))
	    print n, "\t", size, "\t", p, "\t", $14,"\t",val
	}
        /^\+ANALYZER:/ {
	    val = substr($16, 7, length($16))
	    print n, "\t", size, "\t", p, "\t", $14,"\t",val
	}
        /^\-ANALYZER:/ {
	    val = substr($16, 7, length($16))
	    print n, "\t", size, "\t", p, "\t", $14,"\t",val
	}
        /^\.ANALYZER:/ {
	    val = substr($16, 7, length($16))
	    print n, "\t", size, "\t", p, "\t", $14,"\t",val
	}
	# Compute and print the results
	END {
	}

    ' $1 # End of awk
         
