#!/bin/bash

# a script to process the results of alberti run files

# Usage: ./analsumalberti 'regExpr in quotes'
# Example ./analsumalberti 'ga_runs/*run*'

if [ $# -ne 1 ]
    then 
    echo "Usage: ./analsumalberti.sh 'regexp in quotes'"
    echo "Example: ./analsumalberti.sh 'ga_runs/*run*'"
    exit 2
    fi

#echo $1

awk '
        BEGIN {
	    print "RUN\tCHRS\tnINDS\tSHIFTS\tCOLLEN\tNDX1\tNWRG1\tNDX2\tNWRG2\tNDX3\tNWRG3\tNWRG_P\tNWRG_S\tNKEYS\t\tFILE NAME\t\t\tKEY";
	    n = 0
	    nRightP = 0
	    nRightS = 0
	    nCorrectDecrypt = 0
	    sColLen = 0
	    sChrs = 0
	    sKeys = 0
	    sIndys = 0
	}
               
        /^EXPERIMENT:/ {
	    n += 1
	    file = $2
	}
        /^CLEANTEXT/ {
	    len = $2
	    sLen = $6
	    cLen = $8
#	    key = $10
	    sChrs += len
	    sColLen += cLen
	}
        /^GA/ {
	    nIndy = $5
	    sIndys += nIndy
	}
	/^PHASE_1/ {
	    ndx1 = $3
	    nWrongPerm1 = $7
        }
	/^PHASE_2/ {
	    ndx2 = $3
	    nWrongPerm2 = $7
        }
	/^PHASE_3/ {
	    ndx3 = $3
	    nWrongPerm3 = $7
        }
	/^PHASE_4/ {
	    nWrongPermDone = $7
	    nWrongShiftDone = $9
	    if (nWrongPermDone == 0) { nRightP += 1 }
	    if (nWrongShiftDone == 0) { nRightS += 1 }
	    key = $11
	    result = ""
	    if (nWrongShiftDone == 0 && nWrongPermDone == 0) { nCorrectDecrypt += 1 ; result= "\CORRECT" }
	    nKeys = $16
	    sKeys += nKeys
	    print n, "\t", len, "\t", nIndy, "\t", sLen, "\t", cLen, "\t", ndx1, "\t", nWrongPerm1, "\t", ndx2, "\t", 
	    nWrongPerm2, "\t", ndx3, "\t", nWrongPerm3, "\t", nWrongPermDone, "\t", nWrongShiftDone, "\t", nKeys, file, "\t", key, result
        }
	# Compute and print the results
	END {
	    print "\nSUMMARY: N= ", n, "\tInds= ", sIndys/n, "\tCol= ", sColLen/n, "\tChrs= " , sChrs/n, "\tnKeys= " , sKeys/n, 
	    "\tCorrectPerms= ", 100*nRightP/n, "%\tCorrectShifts= ", 100*nRightS/n , "%\tCorrectDecrypt= " , 100*nCorrectDecrypt/n, "%"
	}

    ' $1 # End of awk
         
