#!/bin/bash

# a script to process the results of alberti run files

# Usage: ./analsumalberti 'regExpr in quotes'
# Example ./analsumalberti 'ga_runs/*run*'

if [ $# -ne 1 ]
    then 
    echo "Usage: ./analsumalberti.sh 'regexp in quotes'"
    echo "Example: ./analsumalberti.sh 'ga_runs/*run*'"
    exit 2
    fi

#echo $1

awk '
        BEGIN {
	    print "RUN\tTEXT\tIOC\tKYWD\tWRONG\tWRONG\tEVAL\tRATIO";
	    print "NUM\tSIZE\tVAL\tSIZE\tSHFTS\tCHARS\tEVAL\tRATIO";
	    evalHighRight = 0;
	    evalLowRight = 100000;
	    evalHighWrong = 0;
	    evalLowWrong = 100000;
	    highestVal = 0;
	    lowestVal = 100000;
	    highestValWrong = 0;
	    lowestValWrong = 100000;
            nKeys = 0;
	}
               
        /^EXPERIMENT:/ {
	    n += 1
	    size = $4
	    ic = $6
	    p = $8
	    nWrong = $14
	    mSize += size
	    mIC += ic
	    mP += p
	    if (length($12) == 8) { nWrong = substr($12, 7, 1) }
	    if (length($12) == 9) { nWrong = substr($12, 7, 2) }
	    mNWrong += nWrong
	}
	/^+ RIGHT/ {
	    mNWrong += $3
        }
	/^- WRONG/ {
	    mNWrong += $3
        }
        /^ANALYZER:/ {
	    nWrongCh = $14
	    val = substr($16,7,length($16))
	    if ($14 == 0) { nKeys += $12 }
	    if ($14 == 0) { mValRight += val ; nRight += 1 ; mRatioRight += size/val }
            if ($14 == 0) { if (val > evalHighRight) {evalHighRight = val}}
            if ($14 == 0) { if (val < evalLowRight) {evalLowRight = val}}
            if ($14 == 0) { if (size/val > highestVal) {highestVal = size/val}}
            if ($14 == 0) { if (size/val < lowestVal) {lowestVal = size/val}}
	    if ($14 == 0) {print n, "\t", size, "\t", ic, "\t", p, "\t", nWrong, "\t", nWrongCh, "\t", val, "\t", size/val, "\t", val/size }
	    if ($14 != 0) {print n, "\t", size, "\t", ic, "\t", p, "\t", nWrong, "\t", nWrongCh, "\t", val, "\t", size/val, "\t", val/size }
	    nWrong = ""
	}
        /^+ANALYZER:/ {
	    nWrongCh = $14
	    val = substr($16,7,length($16))
	    if ($14 == 0) { nKeys += $12 }
	    if ($14 == 0) { mValRight += val ; nRight += 1 ; mRatioRight += size/val } else { mValWrong += val; mAnalWrong += 1; mRatioWrong += size/val }
            if ($14 == 0) { if (size/val > highestVal) {highestVal = size/val}}  else { if (size/val > highestValWrong) {highestValWrong = size/val}} 
            if ($14 == 0) { if (size/val < lowestVal) {lowestVal = size/val}}  else { if (size/val < lowestValWrong) {lowestValWrong = size/val}}
	    if ($14 != 0) { if (val < evalLowWrong) { evalLowWrong = val } else if (val > evalHighWrong) { evalHighWrong = val}}
	    if ($14 == 0) {print n, "\t", size, "\t", ic, "\t", p, "\t", nWrong, "\t", nWrongCh, "\t", int(val), "\t", size/val, "\t", val/size }
	    if ($14 != 0) {print n, "\t", size, "\t", ic, "\t", p, "\t", nWrong, "\t", nWrongCh, "\t", int(val), "\t", size/val, "\t", val/size }
	    nWrong = ""
	}
        /^-ANALYZER:/ {
	    nWrongCh = $14
	    val = substr($16,7,length($16))
	    if ($14 == 0) { nKeys += $12 }
	    if ($14 == 0) { mValRight += val ; nRight += 1 ; mRatioRight += size/val } else { mValWrong += val; mAnalWrong += 1; mRatioWrong += size/val }
            if ($14 == 0) { if (size/val > highestVal) {highestVal = size/val}}  else { if (size/val > highestValWrong) {highestValWrong = size/val}}
            if ($14 == 0) { if (size/val < lowestVal) {lowestVal = size/val}} else { if (size/val < lowestValWrong) {lowestValWrong = size/val}}
	    if ($14 != 0) { if (val < evalLowWrong) { evalLowWrong = val } else if (val > evalHighWrong) { evalHighWrong = val}}
	    if ($14 == 0) {print n, "\t", size, "\t", ic, "\t", p, "\t", nWrong, "\t", nWrongCh, "\t", int(val), "\t", size/val, "\t", val/size }
	    if ($14 != 0) {print n, "\t", size, "\t", ic, "\t", p, "\t", nWrong, "\t", nWrongCh, "\t", int(val), "\t", size/val, "\t", val/size }
	    nWrong = ""
	}
	# Compute and print the results
	END {
	    print "AvgSize=" , int(mSize/n), "AvgIC=", mIC/n, "AvgP=", int(mP/n), "AvgKeyLtrsWrong=" , int(mNWrong/n), "nRight=" , nRight, "AvgRightScore=" , mValRight/nRight
	    print "AvgRatioRight=" , mRatioRight/nRight , "HighestVal=" , highestVal, "LowestVal=" , lowestVal
	    print "AvgRatioWrong=" , mRatioWrong/mAnalWrong , "HighestVal=" , highestValWrong, "LowestVal=" , lowestValWrong
	    print "AvgEvalWrong=" , mValWrong/mAnalWrong, "HighestVal=", evalHighWrong, "LowestVal=", evalLowWrong
	    print "AvgEvalRight=" , mValRight/nRight, "HighestVal=", evalHighRight, "LowestVal=", evalLowRight
            print "Avg Number of Keys Searched Given Correct Shift= ", int(nKeys/n)
	}

    ' $1 # End of awk
         
