#!/bin/bash

# a script to process the results of ga_runs files

# Usage: ./analyzeRunGA 'regExpr in quotes'
# Example ./analyzeRunGA 'ga_runs/*run*'

if [ $# -ne 1 ]
    then 
    echo "Usage: ./analyzeRunGA.sh 'regexp in quotes'"
    echo "Example: ./analyzeRunGA.sh 'ga_runs/*run*'"
    exit 2
    fi

#echo $1

awk '
        BEGIN {
	    print "RUN\tNUM \tCGRAM\tWRONG\tFINAL\tPRCNT\tNUM \tFILE";
	    print "NUM\tITER\tLEN  \tCHARS\tSCORE\tWORDS\tKEYS\tNAME"}
               
        /^Experiment/ {
	    experline = $0
	    exper = $2
#            print $0
	}
        /^CRYPTOGRAM Length/ {
           {clen = $3}
	}
        /^GaANALYZER/ {
           {analyzer = $2}
	}
        /^PARAMETERS/ {
	   {file = $2}
           {params = $0}
	}
	/^Finished/ {
	    nr += 1
	    last_finished = $0
	    iter = $4
            sumgen = sumgen + $4            # Sum column 4, number of iterations
	    score = $8
	    keycount = $11
	    totkeycount += keycount
#	    if ($4 != 100)  {s = s + $4; n += 1}   # Count and sum column 4 not equal to 100 (successes)
#		if ($7 != 0)  {tw = tw + $7; ntw += 1} # Count and sum column 7 not equal to 0 (tweaks)
	}
	/^PERCENT WORDS:/ {
    	    {pcw = $3}
	    if ($3 == 100) { pwrds100 += 1}
	    if ($3 >= 90) {pwrds90 += 1}
	    if ($3 >= 75) {pwrds75 += 1}
	    {sumpcw = sumpcw + pcw}
#	    print last_finished " PercentCorrectWords=" $3
#	    last_finished = ""
	}
	/^WRONG CHARS:/ {
	    sumchars = sumchars + $3
	    if ($3 <= 4) { succ += 1}
	    if ($3 == 0) {p100 += 1}
	    if ($3 <= 1) {p1wrong += 1}
	    if ($3 <= 2) {p2wrong += 1}
	    if ($3 <= 3) {p3wrong += 1}

	    print exper "\t" iter "\t" clen "\t" $3 "\t" score "\t" pcw "\t" keycount "\t", " (",file,")"
#	    print last_finished " PercentCorrectWords=" pcw " NumberWrongChars=" $3, " (",file,")"
	    last_finished = ""
	}
	# Compute and print the results
	END {
	    print experline "\n" "ANALYZER: " analyzer "\n" params"\n",
	    "SUMMARY: Success is defined as 4 or fewer wrong characters out of 26",
                "\n\tnRuns=", nr, "\tnSuccess=" , succ, "\tnFailed=", nr-succ, "\tsuccessRate=" ,100*succ/nr, "%",
                "\n\tAvg Keys Search Per Run=", totkeycount/nr, 
                "\n\tAvg Generations Per Run =", sumgen/nr, 
                "\n\tAvg Num Incorrect Chars =", sumchars/nr, 
		"\n\t\t100% --no  chars wrong = ", p100, "(", 100*p100/nr, "%)", 
		"\n\t\t1 or fewer chars wrong = ", p1wrong, "(", 100*p1wrong/nr, "%)",
                "\n\t\t2 or fewer chars wrong = ", p2wrong, "(", 100*p2wrong/nr, "%)",
		"\n\t\t3 or fewer chars wrong = ", p3wrong, "(", 100*p3wrong/nr, "%)", 
                "\n\tAvg Percent Correct Words =", sumpcw/nr, 
		"\n\t\t100% words correct = ", pwrds100, "(", 100*pwrds100/nr, "%)", 
		"\n\t\t     >=90% correct = ", pwrds90, "(", 100*pwrds90/nr, "%)",
                "\n\t\t     >=75% correct = ", pwrds75, "(", 100*pwrds75/nr, "%)"
	}

    ' $1 # End of awk
         
