#!/bin/bash

# a script to process the results of Alberti analyzer files
# This version just analyzes the first 2 parts: finding the period and shift keyword

# Usage: ./analyzeRunGA 'regExpr in quotes'
# Example ./analyzeRunGA 'ga_runs/*run*'

if [ $# -ne 1 ]
    then 
    echo "Usage: ./analyzeRunGA.sh 'regexp in quotes'"
    echo "Example: ./analyzeRunGA.sh 'ga_runs/*run*'"
    exit 2
    fi

#echo $1

awk '
        BEGIN {
#	    print "RUN\tNUM \tCGRAM\tWRONG\tFINAL\tPRCNT\tNUM \tFILE";
#	    print "NUM\tITER\tLEN  \tCHARS\tSCORE\tWORDS\tKEYS\tNAME"
        }
               
        /^File/ {
	    experline = $0
	    exper = $2
            nr += 1
#            print $0
            clen = $4
            totlen += $4
            keylen = $8
            if ($9 == "OK") { nkeylenOK += 1 }
            if ($11 == "RIGHT") { nkeywdOK += 1 }
	}

	# Compute and print the results
	END {
            print "\tnRuns=", nr , "\tavgLen=" , totlen/nr , "\tnKeylenOK=" ,  nkeylenOK , "\tnkeywdOK=" , nkeywdOK ,  "\tkeyLenSuccess=" , 100*nkeylenOK/nr , "%",
		"\tkeyWdSuccess=",  100*nkeywdOK/nr,  "%"
	}

    ' $1 # End of awk
         
