#!/bin/bash

# a script to process the results of Alberti analyzer files
# This version just analyzes the first 2 parts: finding the period and shift keyword

# Usage: ./analyzeRunGA 'regExpr in quotes'
# Example ./analyzeRunGA 'ga_runs/*run*'

if [ $# -ne 1 ]
    then 
    echo "Usage: ./analyzeRunGA.sh 'regexp in quotes'"
    echo "Example: ./analyzeRunGA.sh 'ga_runs/*run*'"
    exit 2
    fi

#echo $1

awk '
        BEGIN {
#	    print "RUN\tNUM \tCGRAM\tWRONG\tFINAL\tPRCNT\tNUM \tFILE";
#	    print "NUM\tITER\tLEN  \tCHARS\tSCORE\tWORDS\tKEYS\tNAME"
	    bysizeNr = 0
	    bysizeClen = 0
	    bysizeNkeylenOK = 0
            bysizeNKeywdOK = 0
	    nWrongChars = 0
            p2 = p3 = p5 = p7 = p9 = p11 = p13 = p17 = p19 = p23 = 0
            p2len = p3len = p5len = p7len = p9len = p11len = p13len = p17len = p19len = p23len = 0
            p2keywd = p3keywd = p5keywd = p7keywd = p9keywd = p11keywd = p13keywd = p17keywd = p19keywd = p23keywd = 0
            p2chars = p3chars = p5chars = p7chars = p9chars = p11chars = p13chars = p17chars = p19chars = p23chars = 0
            p2wrong = p3wrong = p5wrong = p7wrong = p9wrong = p11wrong = p13wrong = p17wrong = p19wrong = p23wrong = 0
	    l300 = l400 = l500 = l600 = l700 = l800 = l900 = l1000 = l1100 = l1200 = l1300 = l1400 = l1500 = 0
	    llen300 = llen400 = llen500 = llen600 = llen700 = llen800 = llen900 = llen1000 = llen1100 = llen1200 = llen1300 = llen1400 = llen1500 0
	    l300len = l400len = l500len = l600len = l700len = l800len = l900len = l100len0 = l1100len = l1200len = l1300len = l1400len = l1500len = 0
	    l3keywd = l4keywd = l5keywd = l6keywd = l7keywd = l8keywd = l9keywd = l1keywd0 = l11keywd = l12keywd = l13keywd = l14keywd = l14keywd = 0
        }
               
        /^File/ {
	    experline = $0
	    exper = $2
            nr += 1
	    bysizeNr += 1
#            print $0
            clen = $4
	    bysizeClen += $4
            totlen += $4
            keylen = $8
            if ($9 == "OK") { nkeylenOK += 1 ; bysizeNkeylenOK += 1}
            if ($11 == "RIGHT") { nkeywdOK += 1 ; bysizeNKeywdOK += 1}
            if ($11 == "WRONG") { nWrong += 1 ; nWrongChars += $12 }
	    if (keylen == 2) { p2 += 1 ; if ($9 == "OK") { p2len += 1 } ; if ($11 == "RIGHT") { p2keywd += 1 } ; if($11 =="WRONG") {p2wrong += 1; p2chars += $12}}
	    if (keylen == 3) { p3 += 1 ; if ($9 == "OK") { p3len += 1 } ; if ($11 == "RIGHT") { p3keywd += 1 } ; if($11 =="WRONG") {p3wrong += 1; p3chars += $12}}
	    if (keylen == 5) { p5 += 1 ; if ($9 == "OK") { p5len += 1 } ; if ($11 == "RIGHT") { p5keywd += 1 } ; if($11 =="WRONG") {p5wrong += 1; p5chars += $12}}
	    if (keylen == 7) { p7 += 1 ; if ($9 == "OK") { p7len += 1 } ; if ($11 == "RIGHT") { p7keywd += 1 } ; if($11 =="WRONG") {p7wrong += 1; p7chars += $12}}
	    if (keylen == 11) { p11 += 1 ; if ($9 == "OK") { p11len += 1 } ; if ($11 == "RIGHT") { p11keywd += 1 } ; if($11 =="WRONG") {p11wrong += 1; p11chars += $12}}
	    if (keylen == 13) { p13 += 1 ; if ($9 == "OK") { p13len += 1 } ; if ($11 == "RIGHT") { p13keywd += 1 } ; if($11 =="WRONG") {p13wrong += 1; p13chars += $12}}
	    if (keylen == 17) { p17 += 1 ; if ($9 == "OK") { p17len += 1 } ; if ($11 == "RIGHT") { p17keywd += 1 } ; if($11 =="WRONG") {p17wrong += 1; p17chars += $12}}
	    if (keylen == 19) { p19 += 1 ; if ($9 == "OK") { p19len += 1 } ; if ($11 == "RIGHT") { p19keywd += 1 } ; if($11 =="WRONG") {p19wrong += 1; p19chars += $12}}
	    if (keylen == 23) { p23 += 1 ; if ($9 == "OK") { p23len += 1 } ; if ($11 == "RIGHT") { p23keywd += 1 } ; if($11 =="WRONG") {p23wrong += 1; p23chars += $12}}
	    if (clen >= 300 && clen < 400) { l300 += 1 ; llen300 += clen ; if ($9 == "OK") { l300len += 1 } ; if ($11 == "RIGHT") { l300keywd += 1 } }
	    if (clen >= 400 && clen < 500) { l400 += 1 ; llen400 += clen ; if ($9 == "OK") { l400len += 1 } ; if ($11 == "RIGHT") { l400keywd += 1 } }
	    if (clen >= 500 && clen < 600) { l500 += 1 ; llen500 += clen ; if ($9 == "OK") { l500len += 1 } ; if ($11 == "RIGHT") { l500keywd += 1 } }
	    if (clen >= 600 && clen < 700) { l600 += 1 ; llen600 += clen ; if ($9 == "OK") { l600len += 1 } ; if ($11 == "RIGHT") { l600keywd += 1 } }
	    if (clen >= 700 && clen < 800) { l700 += 1 ; llen700 += clen ; if ($9 == "OK") { l700len += 1 } ; if ($11 == "RIGHT") { l700keywd += 1 } }
	    if (clen >= 800 && clen < 900) { l800 += 1 ; llen800 += clen ; if ($9 == "OK") { l800len += 1 } ; if ($11 == "RIGHT") { l800keywd += 1 } }
	    if (clen >= 900 && clen < 1000) { l900 += 1 ; llen900 += clen ; if ($9 == "OK") { l900len += 1 } ; if ($11 == "RIGHT") { l900keywd += 1 } }
	    if (clen >= 1000 && clen < 1100) { l1000 += 1 ; llen1000 += clen ; if ($9 == "OK") { l1000len += 1 } ; if ($11 == "RIGHT") { l1000keywd += 1 } }
	    if (clen >= 1100 && clen < 1200) { l1100 += 1 ; llen1100 += clen ; if ($9 == "OK") { l1100len += 1 } ; if ($11 == "RIGHT") { l1100keywd += 1 } }
	    if (clen >= 1200 && clen < 1300) { l1200 += 1 ; llen1200 += clen ; if ($9 == "OK") { l1200len += 1 } ; if ($11 == "RIGHT") { l1200keywd += 1 } }
	    if (clen >= 1300 && clen < 1400) { l1300 += 1 ; llen1300 += clen ; if ($9 == "OK") { l1300len += 1 } ; if ($11 == "RIGHT") { l1300keywd += 1 } }
	    if (clen >= 1400 && clen < 1500) { l1400 += 1 ; llen1400 += clen ; if ($9 == "OK") { l1400len += 1 } ; if ($11 == "RIGHT") { l1400keywd += 1 } }
	    if (clen >= 1500) { l1500 += 1 ; llen1500 += clen ; if ($9 == "OK") { l1500len += 1 } ; if ($11 == "RIGHT") { l1500keywd += 1 } }
	}

	/^SizeChange/ {
	    nWrong = bysizeNr-bysizeNKeywdOK
	    if (nWrong == 0) {
	    print "By Size N=" , bysizeNr , "\tavgLen=" , bysizeClen/bysizeNr , "\tnKeyLenOK=" , bysizeNkeylenOK ,
	           "\tpercent" , 100*bysizeNkeylenOK/bysizeNr , "\tnKeywdOK=" , bysizeNKeywdOK , "\tpercent", 
		   100*bysizeNKeywdOK/bysizeNr , "\tavgWrongChars= 0" 
            }
            if (nWrong != 0) {
	    print "By Size N=" , bysizeNr , "\tavgLen=" , bysizeClen/bysizeNr , "\tnKeyLenOK=" , bysizeNkeylenOK ,
	           "\tpercent" , 100*bysizeNkeylenOK/bysizeNr , "\tnKeywdOK=" , bysizeNKeywdOK , "\tpercent", 
		   100*bysizeNKeywdOK/bysizeNr , "\tavgWrongChars= " , nWrongChars/nWrong
            }
	    bysizeNr = 0
	    bysizeClen = 0
	    bysizeNkeylenOK = 0
            bysizeNKeywdOK = 0
	    nWrongChars = 0
        }


	# Compute and print the results
	END {
            print "SUMMARY \tN=", nr , "\tavgLen=" , int(totlen/nr+0.5) , "\tnKeylenOK=" ,  nkeylenOK , int(100*nkeylenOK/nr+0.5) , "%", "\tnkeywdOK=" , nkeywdOK ,  
		int(100*nkeywdOK/nr+0.5),  "%" , "\tavgWrongChars= " , (nWrong != 0) ? int(nWrongChars/nWrong+0.5) : 0 , "\n"

	    print "Per=2: \t\tN=", p2, "\tlenOK=" , p2len , int(100*p2len/p2+0.5) , "%" "\tkeywdOK=" , p2keywd , int(100*p2keywd/p2+0.5) , "% AvgWrgCh=" , (p2wrong != 0) ? int(p2chars/p2wrong+0.5) : 0 
	    print "Per=3: \t\tN=", p3, "\tlenOK=" , p3len , int(100*p3len/p3+0.5) , "%" "\tkeywdOK=" , p3keywd , int(100*p3keywd/p3+0.5) , "% AvgWrgCh=" , (p3wrong != 0) ? int(p3chars/p3wrong+0.5) : 0 
	    print "Per=5: \t\tN=", p5, "\tlenOK=" , p5len , int(100*p5len/p5+0.5) , "%" "\tkeywdOK=" , p5keywd , int(100*p5keywd/p5+0.5) , "% AvgWrgCh=" , (p5wrong != 0) ? int(p5chars/p5wrong+0.5) : 0 
	    print "Per=7: \t\tN=", p7, "\tlenOK=" , p7len , int(100*p7len/p7+0.5) , "%" "\tkeywdOK=" , p7keywd , int(100*p7keywd/p7+0.5) , "% AvgWrgCh=" , (p7wrong != 0) ? int(p7chars/p7wrong+0.5) : 0 
	    print "Per=11: \tN=", p11, "\tlenOK=" , p11len , int(100*p11len/p11+0.5) , "%" "\tkeywdOK=" , p11keywd , int(100*p11keywd/p11+0.5) , "% AvgWrgCh=" , (p11wrong != 0) ? int(p11chars/p11wrong+0.5) : 0 
	    print "Per=13: \tN=", p13, "\tlenOK=" , p13len , int(100*p13len/p13+0.5) , "%" "\tkeywdOK=" , p13keywd , int(100*p13keywd/p13+0.5) , "% AvgWrgCh=" , (p13wrong != 0) ? int(p13chars/p13wrong+0.5) : 0 
	    print "Per=17: \tN=", p17, "\tlenOK=" , p17len , int(100*p17len/p17+0.5) , "%" "\tkeywdOK=" , p17keywd , int(100*p17keywd/p17+0.5) , "% AvgWrgCh=" , (p17wrong != 0) ? int(p17chars/p17wrong+0.5) : 0 
	    print "Per=19: \tN=", p19, "\tlenOK=" , p19len , int(100*p19len/p19+0.5) , "%" "\tkeywdOK=" , p19keywd , int(100*p19keywd/p19+0.5) , "% AvgWrgCh=" , (p19wrong != 0) ? int(p19chars/p19wrong+0.5) : 0 
	    print "Per=23: \tN=", p23, "\tlenOK=" , p23len , int(100*p23len/p23+0.5) , "%" "\tkeywdOK=" , p23keywd , int(100*p23keywd/p23+0.5) , "% AvgWrgCh=" , (p23wrong != 0) ? int(p23chars/p23wrong+0.5) : 0 
	    print "Total:  \tN=", p2+p3+p5+p7+p11+p13+p17+p19+p23 , "\n"

	    print "Len=300: \tN=", l300, "\tavgLen=" , int(llen300/l300+0.5) , "\tlenOK=" , l300len , int(100*l300len/l300+0.5) , "%" "\tkeywdOK=" , l300keywd , int(100*l300keywd/l300+0.5) , "%"
	    print "Len=400: \tN=", l400, "\tavgLen=" , int(llen400/l400+0.5) , "\tlenOK=" , l400len , int(100*l400len/l400+0.5) , "%" "\tkeywdOK=" , l400keywd , int(100*l400keywd/l400+0.5) , "%"
	    print "Len=500: \tN=", l500, "\tavgLen=" , int(llen500/l500+0.5) , "\tlenOK=" , l500len , int(100*l500len/l500+0.5) , "%" "\tkeywdOK=" , l500keywd , int(100*l500keywd/l500+0.5) , "%"
	    print "Len=600: \tN=", l600, "\tavgLen=" , int(llen600/l600+0.5) , "\tlenOK=" , l600len , int(100*l600len/l600+0.5) , "%" "\tkeywdOK=" , l600keywd , int(100*l600keywd/l600+0.5) , "%"
	    print "Len=700: \tN=", l700, "\tavgLen=" , int(llen700/l700+0.5) , "\tlenOK=" , l700len , int(100*l700len/l700+0.5) , "%" "\tkeywdOK=" , l700keywd , int(100*l700keywd/l700+0.5) , "%"
	    print "Len=800: \tN=", l800, "\tavgLen=" , int(llen800/l800+0.5) , "\tlenOK=" , l800len , int(100*l800len/l800+0.5) , "%" "\tkeywdOK=" , l800keywd , int(100*l800keywd/l800+0.5) , "%"
	    print "Len=900: \tN=", l900, "\tavgLen=" , int(llen900/l900+0.5) , "\tlenOK=" , l900len , int(100*l900len/l900+0.5) , "%" "\tkeywdOK=" , l900keywd , int(100*l900keywd/l900+0.5) , "%"
	    print "Len=1000: \tN=", l1000, "\tavgLen=" , int(llen1000/l1000+0.5) , "\tlenOK=" , l1000len , int(100*l1000len/l1000+0.5) , "%" "\tkeywdOK=" , l1000keywd , int(100*l1000keywd/l1000+0.5) , "%"
	    print "Len=1100: \tN=", l1100, "\tavgLen=" , int(llen1100/l1100+0.5) , "\tlenOK=" , l1100len , int(100*l1100len/l1100+0.5) , "%" "\tkeywdOK=" , l1100keywd , int(100*l1100keywd/l1100+0.5) , "%"
	    print "Len=1200: \tN=", l1200, "\tavgLen=" , int(llen1200/l1200+0.5) , "\tlenOK=" , l1200len , int(100*l1200len/l1200+0.5) , "%" "\tkeywdOK=" , l1200keywd , int(100*l1200keywd/l1200+0.5) , "%"
	    print "Len=1300: \tN=", l1300, "\tavgLen=" , int(llen1300/l1300+0.5) , "\tlenOK=" , l1300len , int(100*l1300len/l1300+0.5) , "%" "\tkeywdOK=" , l1300keywd , int(100*l1300keywd/l1300+0.5) , "%"
	    print "Len=1400: \tN=", l1400, "\tavgLen=" , int(llen1400/l1400+0.5) , "\tlenOK=" , l1400len , int(100*l1400len/l1400+0.5) , "%" "\tkeywdOK=" , l1400keywd , int(100*l1400keywd/l1400+0.5) , "%"
	    print "Len=1500: \tN=", l1500, "\tavgLen=" , int(llen1500/l1500+0.5) , "\tlenOK=" , l1500len , int(100*l1500len/l1500+0.5) , "%" "\tkeywdOK=" , l1500keywd , int(100*l1500keywd/l1500+0.5) , "%"
	    print "Total:  \tN=", l300+l400+l500+l600+l700+l800+l900+l1000+l1100+l1200+l1300+l1400+l1500 , "\n"
	}

    ' $1 # End of awk
         
