#!/bin/bash

# a script to process the results of alberti run files

# Usage: ./analsumalberti 'regExpr in quotes'
# Example ./analsumalberti 'ga_runs/*run*'

if [ $# -ne 1 ]
    then 
    echo "Usage: ./analsumalberti.sh 'regexp in quotes'"
    echo "Example: ./analsumalberti.sh 'ga_runs/*run*'"
    exit 2
    fi

#echo $1

awk '
        BEGIN {
	    print "RUN\tTEXT\tIOC\tKYWD\tWRONG\tNGRM\tADJD\tRETRY";
	    print "NUM\tSIZE\tVAL\tSIZE\tCHARS\tEVAL\tEVAL\tRSULT";
	}
               
        /^EXPERIMENT:/ {
	    n += 1
	    size = $4
	    ic = $6
	    p = $8
	    mSize += size
	    mIC += ic
	    mP += p
	}
        /^ANALYZER:/ {
	    nWrongCh = $10
	    if (nWrongCh <= 1) {nRight += 1}
	    val = substr($12,7,length($12))
	    ratio = size/p/val
	    val = int(10*val+0.5)/10          # Round to 1 place
	    ratio = int(1000*ratio+0.5)/1000
	    print n, "\t", size, "\t", ic, "\t", p, "\t", nWrongCh, "\t", val, "\t", ratio, "\t", $14
	}
	# Compute and print the results
	END {
	    print "Summary:\t" "N=", n, "nRight=", nRight, "%Right=", 100*nRight/n
#	    print "AvgSize=" , int(mSize/n), "AvgIC=", mIC/n, "AvgP=", int(mP/n), "AvgKeyLtrsWrong=" , int(mNWrong/n), "nRight=" , nRight, "AvgRightScore=" , mValRight/nRight
#	    print "AvgRatioRight=" , mRatioRight/nRight , "HighestVal=" , highestVal, "LowestVal=" , lowestVal
#	    print "AvgRatioWrong=" , mRatioWrong/mAnalWrong , "HighestVal=" , highestValWrong, "LowestVal=" , lowestValWrong
#	    print "AvgEvalWrong=" , mValWrong/mAnalWrong, "HighestVal=", evalHighWrong, "LowestVal=", evalLowWrong
#	    print "AvgEvalRight=" , mValRight/nRight, "HighestVal=", evalHighRight, "LowestVal=", evalLowRight
	}

    ' $1 # End of awk
         
