#!/bin/bash

# a script to process the results of ga_runs files

# Usage: ./analyzeRunGA 'regExpr in quotes'
# Example ./analyzeRunGA 'ga_runs/*run*'

if [ $# -ne 1 ]
    then 
    echo "Usage: ./analyzeRunGA.sh 'regexp in quotes'"
    echo "Example: ./analyzeRunGA.sh 'ga_runs/*run*'"
    exit 2
    fi

#echo $1

grep "Finished:" $1 |                          # print lines containing "Finished"
awk '{ if ($4 != 100)  {s = s + $4; n += 1}}   # Count and sum column 4 not equal to 100 (successes)
     { if ($7 != 0)  {tw = tw + $7; ntw += 1}} # Count and sum column 7 not equal to 0 (tweaks)
                                               # Compute and print the results
     END {print "nRuns=", NR, "nSuccess=" , n, "avgSuccess=", s/n, "successRate=" ,n/NR,
                "nFailed=", NR-n, "nTweaked=", ntw, "tweakRate=", ntw/NR}

    '  # End of awk
         
