#!/bin/bash

#a script to run many trials of the
# NgramGaAnalyzer

#To run:  ./testrunGA.sh start count paramfile [description]

trap "" SIGHUP 

short_hostname=`hostname | cut -d. -f1`

if [ $# -lt 3 -o $# -gt 4 ]
    then
    echo 'Usage: ./testrunGA.sh start count paramfile [description]'
    exit 2
    fi
i=$1
count=$2
file=$3
description=""
if [ $# -ge 4 ]
    then
    description=".$4"
    fi

exec < /dev/null > output 2>&1 

while [ $count -gt 0 ]
    do
    echo Running experiment $i `date` on $short_hostname with file $file
    echo Experiment $i `date` on $short_hostname with file $file >> ga_runs/$short_hostname$description.run$i
    time java -classpath ../../classes:. TestGaAnalyzer analyzers.NgramGaAnalyzer $file >> ga_runs/$short_hostname$description.run$i
    i=`expr $i + 1`
    count=`expr $count - 1`
    done



