#!/bin/bash

#a script to run many trials of the
# WordBasedGAAnalyzer

#To run:  ./testrunGA.sh start count paramfile [description]

trap "" SIGHUP 

short_hostname=`hostname | cut -d. -f1`

if [ $# -lt 4 -o $# -gt 5 ]
    then
    echo 'Usage: ./testrunGA.sh start count analyzer paramfile [description]'
    exit 2
    fi
i=$1
count=$2
analyzer=$3
file=$4
description=""
if [ $# -ge 5 ]
    then
    description=".$5"
    fi

exec < /dev/null > output 2>&1 

while [ $count -gt 0 ]
    do
    echo Running experiment $i `date` on $short_hostname with file $file
    echo Experiment $i `date` on $short_hostname with file $file >> final_runs/$short_hostname$description.run$i
    time java -classpath ../../classes:. TestGaAnalyzer $analyzer $file >> final_runs/$short_hostname$description.run$i
    i=`expr $i + 1`
    count=`expr $count - 1`
    done



