public class AlbertiUtility {

/****** Copy this code defining nine methods into the Alphabet class **

* Some of these methods are useful in their own right.

* The static methods may not really belong in the Alphabet class.
*/
 /**
 * alph.strip(str) removes characters in the String str and returns the
 * resulting String.
 * @param str is a String which may have characters not in the alphabet.
 * @result is that String with chars not in the alphabet removed.
 */



 public String strip(String str){
 int len = str.length();
 StringBuffer sb = new StringBuffer(len);
 for (int k = 0; k < len; k++){
 if (isInAlphabet(str.charAt(k)))
 sb.append(str.charAt(k));
 }//for
 return sb.toString();
 } // strip



 /* removeDuplicateChars(str) removes any duplicate characters in a String
 */



 public static String removeDuplicateChars(String str){
 StringBuffer retStr = new StringBuffer();
 char ch; // for use in the loop
 boolean inBuff = false;
 for (int j = 0; j < str.length(); j++){
 ch = str.charAt(j);
 inBuff = false;
 for (int k = 0; k < retStr.length(); k++){
 if (retStr.charAt(k) == ch)
 inBuff = true;
 } // for k
 if (!inBuff)
 retStr.append(ch);
 } // for j
 return retStr.toString();
 } //removeDuplicateChars()



 /**
 * Returns the string of characters which have the positions in the
 * alphabet of the array elements of arr.
 * @param arr is an array of int values corresponding to alphabet elements.
 * @result is a String of corresponding alphabet characters.
 */



 public String intArrayToString(int[] arr){
 try{
 int len = arr.length;
 StringBuffer sb = new StringBuffer(len);
 for (int k = 0; k < len; k++){
 sb.append(intToChar(arr[k]));
 }//for
 return sb.toString();
 } catch(Exception exc) {
 System.out.println(exc.getMessage());
 return "error";
 } // catch



 } // intArrayToString()



 /** createPermutation(str,permArr) writes a permutation to the
 * array permArr which extends the partial mapping described by the
 * string str. So k -> charToInt(str.charAt(k)) for 0 < k < str.length().
 * It is assumed that the number of the integers being permuted is
 * defined by the amount of memory assigned to permArr.
 * @param str is a string with characters in the alphabet.
 * @param permArr is an int array which has been assigned memory.
 */
 public void createPermutation(String str, int[] permArr){
 try{
 str = strip(str);
 str = removeDuplicateChars(str);



 // First copy the integers corresponding to keyStr characters
 for (int k = 0; k < str.length(); k++)
 permArr[k] = charToInt(str.charAt(k));



 //`Next add each integer that has not been used
 boolean inArray = false; // For use in the loop below
 int nextIndex = str.length();
 for (int m = 0; m < permArr.length; m++){
 inArray = false;
 for (int n = 0; n < nextIndex; n++){
 if (permArr[n] == m){
 inArray = true;
 break;
 } // if
 } // for n
 if (!inArray)
 permArr[nextIndex++] = m;
 } // for m



 } catch(Exception exc) {
 System.out.println(exc.getMessage());
 } // catch
 } // createPermutation()



 /** permShift(permIn, shift) returns a permutation which is the composite
 * of permIn followed by shift, that is, k -> shift(permIn(k)). It is assumed
 * that permIn defines a valid permutation and that shift is a valid shift.
 * @param permIn is an int array which defines a valid permutation.
 * @param shift is an int shift between 0 and 1 less than the size of permIn.
 * @result is the int array defining the composite of permIn with shift.
 */
 public static int[] permShift(int[] permIn, int shift){
 if (permIn == null) return permIn; // This error should not happen.
 int permSize = permIn.length;
 int[] permOut = new int[permSize];
 // Compute each new image in a loop
 for (int m = 0; m < permSize; m++){
 permOut[m] = (permIn[m] + shift)%permSize;
 } // for m
 return permOut;
 } // permShift()



 /** shiftPerm(shift, permIn) returns a permutation which is the composite
 * of shift followed by permIn, that is, k -> permIn(shift(k)). It is assumed
 * that permIn defines a valid permutation and that shift is a valid shift.
 * @param shift is an int shift between 0 and 1 less than the size of permIn.
 * @param permIn is an int array which defines a valid permutation.
 * @result is an int array defining the composite of shift with permIn.
 */
 public static int[] shiftPerm(int shift, int[] permIn){
 if (permIn == null) return permIn; // This error should not happen.
 int permSize = permIn.length;
 int[] permOut = new int[permSize];
 // Compute each new image in a loop
 for (int m = 0; m < permSize; m++){
 permOut[m] = permIn[(m + shift)%permSize];
 } // for m
 return permOut;
 } // shiftPerm()



 /** normedShiftString(shStr) returns a String which defines shifts
 * like those defined by shStr only with the first shift subtracted from
 * all of the shifts. Thus for alphabet "az", normedShiftString("xyz")=="abc"
 * @param shStr is a String of chars in the alphabet.
 * @result is the String defining a normalized sequence of shifts in shStr.
 */
 public String normedShiftString(String shStr){
 try{
 if (shStr == null) return "error"; // This error should not happen.



 StringBuffer sb = new StringBuffer();
 int num; // For use in the loop.
 // Compute each new char in a loop.
 for (int m = 0; m < shStr.length(); m++){
 if (isInAlphabet(shStr.charAt(m))){
 num = charToInt(shStr.charAt(m)) - charToInt(shStr.charAt(0));
 num = (size + num)%size;
 sb.append(intToChar(num));
 } // if
 } // for m
 return sb.toString();



 } catch(Exception exc) {
 System.out.println(exc.getMessage());
 return "error";
 } // catch



 } // normedShiftString()



 /** eAlbNormedPermString(permStr, shStr) returns a String which defines
 * the permutation of permStr followed by the first shift defined in shStr.
 * This permutation and the normed shift string of shStr are keys that give
 * precisely the same easy Alberti cipher as the keys permStr and shStr.
 * @param permStr is a String of chars in the alphabet defining a permutation.
 * @param shStr is a String of chars in the alphabet defining a sequence of shifts.
 * @result is the String defining the normalized easy Alberti permutation.
 */
 public String eAlbNormedPermString(String permStr, String shStr){
 try{
 int[] permIn = new int[size];
 createPermutation(permStr, permIn);
 int shift = charToInt(shStr.charAt(0));
 int[] permOut = permShift(permIn, shift);
 String strOut = intArrayToString(permOut);
 return strOut;



 } catch(Exception exc) {
 System.out.println(exc.getMessage());
 return "error";
 } // catch



 } // eAlbNormedPermString()



 /** dAlbNormedPermString(shStr, permStr) returns a String which defines
 * the first shift defined in shStr followed by the permutation of permStr.
 * This permutation and the normed shift string of shStr are keys that give
 * precisely the same difficult Alberti cipher as the keys shStr and permStr.
 * @param shStr is a String of chars in the alphabet defining a sequence of shifts.
 * @param permStr is a String of chars in the alphabet defining a permutation.
 * @result is the String defining the normalized difficult Alberti permutation.
 */
 public String dAlbNormedPermString(String shStr, String permStr){
 try{
 int[] permIn = new int[size];
 createPermutation(permStr, permIn);
 int shift = charToInt(shStr.charAt(0));
 int[] permOut = shiftPerm(shift, permIn);
 String strOut = intArrayToString(permOut);
 return strOut;
 } catch(Exception exc) {
 System.out.println(exc.getMessage());
 return "error";
 } // catch
 } // dAlbNormedPermString()




//main method for testing above methods

public static void main(String args[]){

 try{
 System.out.println("\nTesting methods for normalizing Alberti keys:");
 char [] azRange ={'a', 'z'};
 Alphabet alph = new Alphabet(azRange);
 String albShiftStr = "mnabyz";
 String albPermStr = "crazyasafox";



 // Here are the three functions I felt you wanted

 String nAlbShiftStr = alph.normedShiftString(albShiftStr);
 String nEAlbPermStr = alph.eAlbNormedPermString(albPermStr, albShiftStr);
 String nDAlbPermStr = alph.dAlbNormedPermString(albShiftStr, albPermStr);



 // This tests that the three functions arecreating alternate strings
 System.out.println("The shift string: " + albShiftStr);
 System.out.println(" is normalized to: " + nAlbShiftStr);
 System.out.println("The Alberti permutation string: " + albPermStr);
 System.out.print(" is normalized, in easy case, to: ");
 System.out.println(nEAlbPermStr);
 System.out.print(" and normalized, in difficult case, to: ");
 System.out.println(nDAlbPermStr);



 // Now you need to test that your easy Alberti with keysalbPermStr and albShiftStr

 // enciphers and deciphers exactly as with keys nEAlbPermStr and nAlbShiftStr

 //And you need to test that yourdifficult Alberti with keysalbPermStr and albShiftStr

 // enciphers and deciphers exactly as with keys nDAlbPermStr and nAlbShiftStr

 } catch(Exception exc) {
 System.out.println(exc.getMessage());
 } // catch
} // main()
}
