    private void init(double arr[][], double v) {
	for(int j = 0; j < arr.length; j++)
	    for (int k = 0; k < arr[j].length; k++)
		arr[j][k] = v;
    }

    private double sumCol(double arr[][], int c) {
	double sum = 0;
	for (int k = 0; k < arr.length; k++)
	    sum += arr[k][c];
	return sum;
    }

    private double sumRow(double arr[][], int r) {
	double sum = 0;
	for (int k = 0; k < arr[0].length; k++)
	    sum += arr[r][k];
	return sum;
    }

    private void normalize(double arr[][]) {
	for (int k = 0; k < arr.length; k++) {
	    double sum = 0;
	    for (int j = 0; j < arr[k].length; j++)
		sum += arr[k][j];
	    for (int j = 0; j < arr[k].length; j++)
		arr[k][j] /= sum;
	}
    }

    private void print(double arr[][]) {
	java.text.NumberFormat nf = java.text.NumberFormat.getNumberInstance();
	nf.setMaximumFractionDigits(3);
	for(int j = 0; j < arr.length; j++) {
	    for (int k = 0; k < arr[j].length; k++)
		System.out.print(nf.format(arr[j][k]) + " ");
	    //		System.out.print(arr[j][k] + " ");
	    System.out.println();
	}
    }

    private double EMSearch(String text, int period)  {
	System.out.println("\nEM Search");
	double permutationMatrix[][] = new double[26][26];  // [plainChar, cipherChar]
	double shiftMatrix[][] = new double[period][26];
	double likelihoods[][] = new double[26][26]; // [plainChar,cipherChar]

	init(permutationMatrix, 1.0/26.0);  // All equally likely initially
	init(shiftMatrix, 1.0/26.0);

	NgramArray nga;
	try {
	    nga = new NgramArray(3, params.book, AlphabetFactory.getInstance(AlphabetFactory.ALPH_az));
	    
	    init(likelihoods,1);
	    for (int k = 1; k < text.length()-1; k++) {        // For each trigram in ciphertext
		int V = text.charAt(k) - 'a';    
		int U = text.charAt(k-1) - 'a';
		int W = text.charAt(k+1) - 'a';
		for (int beta = 0; beta < 26; beta++) {      // For each plain character 'a' to 'z'
		    double colSumU = sumCol(permutationMatrix, U);  
		    double colSumW = sumCol(permutationMatrix, W);  
		    for (int alpha = 0; alpha < 26; alpha++) {
			for (int gamma = 0; gamma < 26; gamma++) {
			    String trigram = "" + (char) (alpha + 'a') + (char) (beta + 'a') + (char) (gamma + 'a');
			    double val = colSumU * colSumW  * nga.getNGramProb(trigram);
			    likelihoods[beta][V] *= val;
			    //			    System.out.println((char)(V+'a') + "-->" + (char)(beta+'a') + " " + val);
			}
		    }
		}
	    }
	    print(likelihoods);
	    init(permutationMatrix, 1.0);
	    for (int j = 0; j < 26; j++) 
		for (int k = 0; k < 26; k++) {
		    permutationMatrix[k][j] *= likelihoods[k][j];
		}
	    normalize(permutationMatrix);
	    print(permutationMatrix);

	} catch (Exception e) {
	    System.out.println("Problem with NgramArray: " + e.getMessage());
	    e.printStackTrace();
	}
	return 0;
    }
    
