import java.io.*;
import java.util.*;
import java.text.*;


public class LearnParameters {

    private static final double DELTA = 0.0018;
    
    
    private static final double EPSILON = 0.42;
    
    public static void main(String args[]) throws IOException {
	NumberFormat nf = NumberFormat.getInstance();
	nf.setMaximumFractionDigits(4);
	BufferedReader instream = new BufferedReader(new FileReader("albertilearningdata.txt"));
	StringTokenizer st = null;
	int currN = 0, prevN = 0;
	int size = 0;
	int P = 0;
	int wrongChars = 0;
	double prevScore = 0, currScore = 0;
	int nTrials = 0, nSuccess = 0, nConfirmed = 0, nImproves = 0, nImproveConfirmed = 0, falsePos = 0, nPluses = 0;
	String line = instream.readLine();
	double baseScore = 0;
	while (line != null) {
	    //	    System.out.println(line);
	    st = new StringTokenizer(line);
	    currN = Integer.parseInt(st.nextToken());
	    size = Integer.parseInt(st.nextToken());
	    P = Integer.parseInt(st.nextToken());
	    wrongChars = Integer.parseInt(st.nextToken());
	    currScore = Double.parseDouble(st.nextToken());
	    System.out.print(currN + "\t" + size + "\t" + P + "\t" + wrongChars + "\t" + nf.format(currScore) + "\t" + nf.format(baseScore));
	    double ratio = size/P/currScore;
	    System.out.print("\tRatio= " + nf.format(ratio));
	    //	    double diff = ratio - size/P/prevScore;
	    if (currN == prevN) { // If this is a retry
		double diff = ratio - size/P/baseScore;
		String ch = st.nextToken();
		if (ch.equals("+"))
		    ++nPluses;
		System.out.print("\t" + ch);
		System.out.print("\tDiff= " + nf.format(diff));
		if (diff >= DELTA) {
		    ++nImproves;
		    baseScore = currScore;         // Base score improves
		    System.out.print("\tIMPROVEMENT");
		    if (ch.equals("+")) {
			++nImproveConfirmed;
			System.out.print(" CONFIRMED");
		    } else {
			System.out.print(" FALSE_POSITIVE");
			++falsePos;
		    }
		}
	    } else {
		baseScore = currScore;              // Initialize base score
		++nTrials;  // New Trial
		//		System.out.println("Trial=" + nTrials);
	    }
	    if (ratio >= EPSILON) {
		System.out.print("\tSUCCESS");
		++nSuccess;
		if (wrongChars <= 1) {
		    System.out.println(" CONFIRMED");
		    ++nConfirmed;
		} else
		    System.out.println();
	    }
	    else {
		System.out.println();
		prevN = currN;
		prevScore = currScore;
	    }
	    
	    
	    line = instream.readLine();
	}
	instream.close();
	System.out.println("NTrials= " + nTrials + "\tnSuccess= " + nSuccess + "\tRate= " + nf.format(100.0 * nSuccess/nTrials) + "%" + "\tnConfirmed= " + nConfirmed + 
			   "\tnPluses= " + nPluses + "\tnImproves= " + nImproves + "\tnConfirmedImproves= " + nImproveConfirmed + "\tfalsePos= " + falsePos + "\tfalseNegs= " + (nPluses-nImproves));
    }
}
