

public class TestMoveSegments {

/* Copy this into the class where the 'key' variable is???
*/

     // A memory location that is used by moveSegment() in order
     // to avoid reallocating memory every time a key is modified.
     // WARNING: This assumes an Alphabet of 26 letters
     public StringBuffer tempKey =
         new StringBuffer("zyxwvutsrqponmlkjihgfedcba");

    /**
     *  moveSegments(key,m1,n1,m2,n2) modifies key by exchanging the segment
     *  from first letter at m1 to last letter at n1 with the segment from m2
     *  to n2.  The characters between the two segments are shifted as needed.
     *  @param key is a permutation key stored in a StringBuffer variable.
     *  @param m1 is a location of the first letter of a first segment. 1 <= m1 <=24
     *  @param n1 is a location of the last letter of a first segment. m1 <= n1 <=24
     *  @param m2 is a location of the 1st letter of a 2nd segment. n1< m2 <=25
     *  @param n2 is a location of the 1st letter of a 2nd segment. m2 <= n2 <=25
     */
     public void moveSegments(StringBuffer key, int m1, int n1, int m2, int n2){
         for (int k = 0; k < 26; k++)             // Copy key to tempKey
             tempKey.setCharAt(k,key.charAt(k));
         int tempKeyPos = m2;
         int keyPos = m1;
         while (tempKeyPos <= n2){         //copy second segment to key
             key.setCharAt(keyPos,tempKey.charAt(tempKeyPos));
             tempKeyPos++;
             keyPos++;
         } // while
         tempKeyPos = n1 + 1;
	 while (tempKeyPos < m2){           // copy chars between segments to key
             key.setCharAt(keyPos,tempKey.charAt(tempKeyPos));
             tempKeyPos++;
             keyPos++;
         } // while
         tempKeyPos = m1;
          while (tempKeyPos <= n1){          // copy first segment to key
             key.setCharAt(keyPos,tempKey.charAt(tempKeyPos));
             tempKeyPos++;
             keyPos++;
         } // while
     } // moveSegments()



//The method below does something different each time but chooses the second
// segment near the end of alphabet much too often.
//This would need to be improved
     /**
     *  randMoveSegments(key) modifies key by exchanging two randomly selected
     *  segments of key.
     *  @param key is a permutation key stored in a StringBuffer variable.
     */
     public void randMoveSegments(StringBuffer key){
         int m1 = 1 + (int)(Math.random() * 24 );
         int n1 = m1 + (int)(Math.random() * (25 - m1));
         int m2 = n1 + 1 + (int)(Math.random() * (25 - n1));
         int n2 = m2 + (int)(Math.random() * (26 - m2));
         moveSegments(key,m1,n1,m2,n2);
     } //randMoveSegments()

    public static void cross(StringBuffer s1, StringBuffer s2, int p, int len) {
	int NN=4;
	//	int p = (int)(Math.random() * key.length());
	int pstop = p + len;
	//	System.out.println("Swapping from " + p + " to " + pstop);
	while (p < pstop && p < s1.length()) 
	    //	while (p < pstop && p < key.length() && p2 < p2stop && p2 < key.length()) 
	{
	    char ch1 = s1.charAt(p);
	    char ch2 = s2.charAt(p);
	    //	    char ch2 = i2.key.charAt(p2);
	    swap(s1, ch1, ch2);
	    swap(s2, ch1, ch2);
	    p++;
	    //	    p2++;
	}
    }

    public static void cross(StringBuffer s1, StringBuffer s2, int p, int p2, int len) {
	int NN=4;
	//	int p = (int)(Math.random() * key.length());
	int pstop = p + len;
	int pstop2 = p2 + len;
	//	System.out.println("Swapping from " + p + " to " + pstop);
	while (p < pstop && p < s1.length() && p2 < pstop2 && p2 < s2.length()) 
	{
	    char ch1 = s1.charAt(p);
	    char ch2 = s2.charAt(p);
	    //	    char ch2 = i2.key.charAt(p2);
	    swap(s1, ch1, ch2);
	    swap(s2, ch1, ch2);
	    p++;
	    p2++;
	}
    }

    public static void crossNoCollision(StringBuffer s1, StringBuffer s2, int p, int p2, int len) {
	int NN=4;
	//	int p = (int)(Math.random() * key.length());
	int pstop = p + len;
	int pstop2 = p2 + len;
	String str1 = s1.substring(p,pstop);
	String str2 = s2.substring(p2,pstop2);
	int count = 0;
	while (collision(s1.substring(p,pstop), s2.substring(p2,pstop2)) || 
	       collision(s1.substring(p,pstop), s2.substring(p,pstop)) ||
	       collision(s1.substring(p2,pstop2), s2.substring(p2,pstop2)) ) {
	    ++count;
	    if (count >= 26) 
		break;
	    p--; pstop--; 
	    if (p < 0) { pstop = s1.length()-1; p = pstop - len; }
	    //	    System.out.println(" p= " + p + " pstop= " + pstop);
	}
	//	System.out.println(" p= " + p + " p2= " + p2);
	if (count >= 26)
	    return;

	//	System.out.println("Swapping from " + p + " to " + pstop);
	while (p < pstop && p < s1.length() && p2 < pstop2 && p2 < s2.length()) 
	{
	    char ch1 = s1.charAt(p);
	    char ch2 = s2.charAt(p);
	    //	    char ch2 = i2.key.charAt(p2);
	    swap(s1, ch1, ch2);
	    swap(s2, ch1, ch2);
	    p++;
	    p2++;
	}
    }

    private static boolean collision(String s1, String s2) {
	for (int k = 0; k < s1.length(); k++) 
	    if (s2.indexOf(s1.charAt(k)) != -1)
		return true;
	return false;
    }
						   
    public static void swap (StringBuffer sb, char ch1, char ch2) {
	//	System.out.print("key " + sb.toString() + " --> ");
        int m = sb.toString().indexOf(ch1);
        int n = sb.toString().indexOf(ch2);
        sb.setCharAt(m, ch2);
        sb.setCharAt(n, ch1);        
	//	System.out.println("Swap " + ch1 + " " + ch2 + " " + sb.toString());
    }

    public static StringBuffer cut(StringBuffer sb, int p) {
	StringBuffer newSb = new StringBuffer(sb.substring(p));
	newSb.append(sb.substring(0,p));
	return newSb;
    }

    public static StringBuffer reverse(StringBuffer sb) {
	StringBuffer sbNew = new StringBuffer();
	for (int k = sb.length()-1; k >= 0; k--)
	    sbNew.append(sb.charAt(k));
	return sbNew;
    }

    public static StringBuffer shiftL(StringBuffer sb) {
	StringBuffer sbNew = new StringBuffer();
	int p = 2 + (int)(Math.random() * 19);
	int l = Math.min(2 + (int)(Math.random() * 5), 25 - p);
	sbNew.append(sb.substring(0,p));
	sbNew.append(sb.substring(p+1,p+1+l));
	sbNew.append(sb.charAt(p));
	sbNew.append(sb.substring(p+1+l));
	return(sbNew);
    }

    public static StringBuffer rotateL(StringBuffer sb) {
	return cut(sb,1);
    }
    public static StringBuffer rotateR(StringBuffer sb) {
	return cut(sb,sb.length()-1);
    }

    private static void compareTwoKeys(String key1, String key2) {
	for (int k = 1; k < key1.length(); k++) {
	    char ch1 = key1.charAt(k-1);
	    char ch2 = key1.charAt(k);
	    int indx1 = key2.indexOf(ch1);
	    int indx2 = key2.indexOf(ch2);
	    int diff = indx2 - indx1;
	    if (diff < 0)
		diff = 26 + diff;
	    System.out.println(((char)ch1) + "" + ((char)ch2) + " " + diff);
	}
    }


  public static void main(String[] args){
      //                                  01234567890123456789012345
      //      StringBuffer s1 = new StringBuffer("egbcdhifasjlmnpqtkruvwoxyz");
      //      StringBuffer s2 = new StringBuffer("egbcdhifasjlmnpqrutkvwoxyz");
      //      StringBuffer s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
      //      StringBuffer s2 = new StringBuffer("jklmnopqrstuvwxyzabcdefghi");
      StringBuffer s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
      StringBuffer s2 = new StringBuffer("defghijklmnopqrstuvwxyzabc");

      //      String key1 = "egprhqwisajvtkxublyncmzdfo";
      String key1 = "egprlhqwisajbvtkxuncmyzdfo";  // partially correct
      //      String key2 = "eqjucohaxnfrskydpitlzgwvbm";
      //      String key2 = "eqjzgwvitlrskydaxnfpucohbm";  // partially correct
      String key2 = "eqjyohrskitlvmbcuaxnfpdzgw"; // partially correct
      compareTwoKeys(key1, key2);

      /********
      for (int k = 0; k < 26; k++) {
	  String str1 = s1.substring(0,(int)(Math.random() * 26));
	  String str2 = s2.substring(0,(int)(Math.random() * 26));
	  System.out.print("Collision of " + str1 + " and " + str2 + " is " );
	  System.out.println(collision(str1, str2));
      }

      System.out.println("\ns1= " + s1.toString());
      System.out.println("s2= " + s2.toString());
      System.out.println("Crossing 3 letters in s1 and s2 at 0");
      cross(s1,s2,0,3);
      System.out.println("s1= " + s1.toString());
      System.out.println("s2= " + s2.toString());
      s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
      s2 = new StringBuffer("defghijklmnopqrstuvwxyzabc");
      System.out.println("\ns1= " + s1.toString());
      System.out.println("s2= " + s2.toString());
      System.out.println("Crossing 3 letters in s1 and s2 at 5 and 10");
      crossNoCollision(s1,s2,5, 10,3);
      System.out.println("s1= " + s1.toString());
      System.out.println("s2= " + s2.toString());
      s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
      s2 = new StringBuffer("defghijklmnopqrstuvwxyzabc");
      System.out.println("\ns1= " + s1.toString());
      System.out.println("s2= " + s2.toString());
      System.out.println("Crossing 4 letters in s1 and s2 at 13 and 17");
      crossNoCollision(s1,s2, 13, 17,4);
      System.out.println("s1= " + s1.toString());
      System.out.println("s2= " + s2.toString());

      s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
      s2 = new StringBuffer("defghijklmnopqrstuvwxyzabc");
      System.out.println("\ns1= " + s1.toString());
      System.out.println("s2= " + s2.toString());
      System.out.println("Crossing 4 letters in s1 and s2 at 5 and 9");
      crossNoCollision(s1,s2, 5, 9,4);
      System.out.println("s1= " + s1.toString());
      System.out.println("s2= " + s2.toString());

      s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
      s2 = new StringBuffer("defghijklmnopqrstuvwxyzabc");
      System.out.println("\ns1= " + s1.toString());
      System.out.println("s2= " + s2.toString());
      System.out.println("Crossing 3 letters in s1 and s2 at 5 and 9");
      crossNoCollision(s1,s2, 5, 9,3);
      System.out.println("s1= " + s1.toString());
      System.out.println("s2= " + s2.toString());
      **********/

      /**********

      for (int k = 0; k < 10; k++) {
	  s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
	  int p = 1 + (int)(Math.random() * (s1.length() - 1));
	  System.out.println("ShiftL " + s1 + ": " + shiftL(s1).toString());
      }

      for (int k = 0; k < 10; k++) {
	  s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
	  int p = 1 + (int)(Math.random() * (s1.length() - 1));
	  System.out.println("Cutting " + s1 + " at "  + p + " = " + cut(s1,p).toString());
      }

      s1 = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
      System.out.println("Reverse of " + s1.toString() + " = " + reverse(s1).toString());
      System.out.println("RotateL of " + s1.toString() + " = " + rotateL(s1).toString());
      System.out.println("RotateR of " + s1.toString() + " = " + rotateR(s1).toString());

      StringBuffer key  = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
      TestMoveSegments tms = new TestMoveSegments();
      System.out.println("before moveSegments(key,5,7,13,20): " + key.toString());
      tms.moveSegments(key,5,7,13,20);
      System.out.println("after  moveSegments(key,5,7,13,20): " + key.toString());

      for (int j = 0; j <= 5; j++){
          key  = new StringBuffer("abcdefghijklmnopqrstuvwxyz");
          System.out.println("\nbefore randMoveSegments(key): " + key.toString());
          tms.randMoveSegments(key);
          System.out.println("after  randMoveSegments(key): " + key.toString());
      } // for
      *********/
  }//main()
} //TestMoveSegments class
