class em {
  double[][] Data;
  int        M;
  int        N;
  int        d;

  double[]   P;		// Mixing Parameters
  double[][] u;		// Mean
  double[]   v;         // Variance

  double[]   P_old;	// Mixing Parameters
  double[][] u_old;	// Mean
  double[]   v_old;     // Variance

  double[]   P_x;	// P_x calculation results
  double[]   P_x_old;	// P_x calculation results

  double[]   Min;	// Maximum of each dimension
  double[]   Max;	// Minimum of each dimension

  em(double[][] Data, int M) {
    initialize(Data);
    setParameter(M);
  }

  em(double[][] Data) {
    initialize(Data);
  }

  private void initialize(double[][] Data)
  {
    this.Data  = Data;
    this.N = Data.length;
    this.d = Data[0].length;
    Min   = new double[d];
    Max   = new double[d];
    int n,i,j;
    for(i=0;i<d;i++) {
      Min[i] = Data[0][i];
      Max[i] = Data[0][i];
      for(n=1;n<N;n++) {
        if(Min[i] > Data[n][i]) Min[i] = Data[n][i]; else
        if(Max[i] < Data[n][i]) Max[i] = Data[n][i];
      }
    }
  }

  void setParameter(int M)
  {
    int i,j;
    double var = 0.0;
    this.M = M;
    P = new double[M];
    u = new double[M][d];
    v = new double[M];
    P_old = new double[M];
    u_old = new double[M][d];
    v_old = new double[M];
    P_x   = new double[N];
    P_x_old = new double[N];
    for(i=0;i<d;i++)
      var += (Max[i] - Min[i]) * (Max[i] - Min[i]) / 12 / d;
    for(j=0;j<M;j++)
    {
      P[j] = 1.0 / (double)M;
      v[j] = var / 4 + Math.random() * var / 4; 
      for(i=0;i<d;i++)
        u[j][i] = (Max[i] + Min[i]) / 2 +
                  (Math.random() - 0.5 ) *  (Max[i] - Min[i]) / 2;
    }
  }

  void new_old()
  {
    int i,j;
    for(j=0;j<M;j++)
    {
      P_old[j] = P[j];
      v_old[j] = v[j];
      for(i=0;i<d;i++)
        u_old[j][i] = u[j][i];
    }
  }

  double P_x_j(int n, int j)
  {
    int i;
    double e = 0.0;
    for(i=0;i<d;i++)
      e += (Data[n][i] - u[j][i]) * (Data[n][i] - u[j][i]);
    e /= -2 * v[j] * v[j];
    return Math.exp(e) / Math.pow(2 * Math.PI * v[j] * v[j], (double)d / 2.0); 
  } 

  double P_j_x(int n, int j)
  {
    return P_x_j(n,j) * P[j] / P_x[n];
  }

  void P_x()
  {
    int n,j;
    for(n=0;n<N;n++)
    {
      double temp = 0.0;
      for(j=0;j<M;j++)
        temp += P_x_j(n,j) * P[j];
      P_x[n] = temp;
    }
  }

  double P_x_j_old(int n, int j)
  {
    int i;
    double e = 0.0;
    for(i=0;i<d;i++)
      e += (Data[n][i] - u_old[j][i]) * (Data[n][i] - u_old[j][i]);
    e /= -2 * v_old[j] * v_old[j];
    return Math.exp(e) / Math.pow(2 * Math.PI * v_old[j] * v_old[j],
                         (double)d / 2.0); 
  } 

  double pdf(double[] x)
  {
    int i,j;
    double e = 0.0;
    double t = 0.0;
    for(j=0;j<M;j++) {
      for(i=0;i<d;i++)
        e += (x[i] - u[j][i]) * (x[i] - u[j][i]);
      e /= -2 * v[j] * v[j];
      e = Math.exp(e) / Math.pow(2 * Math.PI * v[j] * v[j],(double)d / 2.0); 
      t += e*P[j];
    }
    return t;
  }

  double P_j_x_old(int n, int j)
  {
    return P_x_j_old(n,j) * P_old[j] / P_x_old[n];
  }

  void P_x_old()
  {
    int n,j;
    for(n=0;n<N;n++)
    {
      double temp = 0.0;
      for(j=0;j<M;j++)
        temp += P_x_j_old(n,j) * P_old[j];
      P_x_old[n] = temp;
    }
  }

  void iteration()
  {
    int i,j,n;
    new_old();
    P_x();
    P_x_old();
  
    // calculate new mean & variance

    for(j=0;j<M;j++)
    {
      double denom = 0.0;
      for(n=0;n<N;n++)
        denom += P_j_x_old(n,j);
 
      for(i=0;i<d;i++)
      { 
        u[j][i] = 0.0;
        for(n=0;n<N;n++)
          u[j][i] += P_j_x_old(n,j) * Data[n][i];
        u[j][i] /= denom;
      }
    
      v[j] = 0.0;
      for(n=0;n<N;n++)
      {
        double sum = 0.0;
        for(i=0;i<d;i++)
           sum += (Data[n][i] - u[j][i]) * (Data[n][i] - u[j][i]);
        v[j] += sum * P_j_x_old(n,j);
      }
      v[j] /= denom * d;
      v[j] = Math.sqrt(v[j]);
 
      P[j] = denom / (double)N;
    }
  }



  void display()
  {
    String newline = System.getProperty("line.separator");
    int i,j;
    for(j=0;j<M;j++)
    {
      System.out.print("P[" + j + "] = " + P[j] + newline);
      System.out.print("V[" + j + "] = " + v[j] + newline);
      System.out.print("u[" + j + "] = ");
      for(i=0;i<d;i++)
         System.out.print(u[j][i] + " ");
      System.out.print(newline);
    }
    System.out.print(newline);
  }
}

