/* 
 * File: TestAnalyzer.java
 * Author: R. Morelli
 * Description: An implementation of a trivial Analyzer plugin. 
 */

package analyzers;             // Analyzer plugins belong to this package
import hcrypto.analyzer.*;     // This is where Analyzer is
import java.awt.*;
import java.awt.event.*;


public class TestAnalyzer extends AnalyzerFrame implements Analyzer {

    private String text;             // Pointer to the text to be analyzed
    private StringBuffer resultSB = new StringBuffer();

    public TestAnalyzer() {
	setTitle("TestAnalyzer");
	display.append("This is a test analyzer with a GUI interface.\n");
    }
    
    
    /**
     * setup() is part of Analyzer interface. It passes in the pointer
     *  to the text.
     */     
    //    public void setup(TextArea text, TextArea display) { 
    public void setup(String text) { 
        this.text = text;
    }
    
    /**
     * run() is part of Analyzer interface. It performs the analysis.
     */     
    public void run() {
        resultSB.append("TestAnalyzer: First 10 characters of the cryptogram = " +
			text.substring(0,10) + "\n");
    }
    
    
    /**
     * getResult() is part of Analyzer interface. It returns the result
     *  as a string.
     */     
    public String getReport() {
	display.append(resultSB.toString() + "\n");
        return toString();
    }

    /**
     * toString() returns the result
     */     
    public String toString() {
        return resultSB.toString();
    }
}
