/*
 * File: TypeIVGaAnalyzer.java
 * @author R. Morelli <ralph.morelli@trincoll.edu> 
 * 
 * Description: This class assumes that the text is encrypted with a TypeIV cipher. 
 * A TypeIV cipher consists of three keys: a permutation of the plain alphabet,
 * a permutation of the cipher alphabet, and a sequence of shifts. A TypeIII cipher
 * is one in which the same permutation is used for both the plain and cipher 
 * alphabets.
 *
 *  To compile and run from the TestAnalyzer application:
 *
 *  cd ~crypto/hcryptoj/1.4/applications/testanalyzer
 *  javac -classpath ../../classes -d ../../classes TypeIVGaAnalyzer.java
 *  java -classpath ../../classes:. TestGaAnalyzer analyzers.TypeIVGaAnalyzer ga_paramfiles/albertiparam.txt
 *
 */

package analyzers;

import hcrypto.analyzer.*;
import hcrypto.cipher.*;
import hcrypto.engines.*;
import hcrypto.provider.*;

import java.util.*;
import java.io.*;

public class TypeIVGaAnalyzer extends CryptoAnalyzer implements Analyzer 
{

    private int shiftLen;
    private String cleantext;
    private String actualKeywd;
    
    protected GaPopulation population;     

    /**
     * TypeIVGaAnalyzer() -- Default constructor
     */
    public TypeIVGaAnalyzer() 
    {
	super();
    }

    /**
     * TypeIVGaAnalyzer() -- this constructor is given an object containing parameter settings
     * @param params -- an object containing param1=val1 param2=val2 ...
     */
    public TypeIVGaAnalyzer(GaParameters params) 
    {
	super(params);
    }

    /**
     * setup() creates the population for the GA.
     */
    public void setup(String text) 
    {
	super.setup(text);
	if (params == null) {
	    params = new GaParameters();       // Default GaParameters
	}
        cleantext = TextUtilities.cleanString(this.text.toLowerCase());
        cleantext = TextUtilities.removeWhiteSpace(cleantext);

	String keyspec = this.solution.substring(this.solution.indexOf("#")+1,this.solution.indexOf('/'));
	//	actualKeywd  = keyspec.substring(keyspec.indexOf(',')+1);
	actualKeywd  = keyspec.substring(keyspec.lastIndexOf(',')+1);
        int actualKeywdLen = actualKeywd.length();
	//	System.out.println("\tshiftword= " + actualKeywd + " l= " + actualKeywdLen);

	this.solution = TextUtilities.cleanString(this.solution.toLowerCase());
        this.solution = TextUtilities.removeWhiteSpace(this.solution);

	ShiftLengthAnalyzer shiftLengthAnalyzer = new ShiftLengthAnalyzer();
        shiftLen = shiftLengthAnalyzer.findShiftLength(cleantext);
        System.out.println("\nCLEANTEXT_LEN= " + cleantext.length()
			   + "\tSOLUTION_LEN= " + this.solution.length()
			   + "\tSHIFT_LEN= " + shiftLen 
			   + "\tCOLUMN_LEN= " + cleantext.length()/shiftLen
			   + "\tkey= " + keyspec
			   );
	//        System.out.println("\nText = \n" + cleantext);
	//        System.out.println("\nSolution = \n" + this.solution);

	analyzeText(cleantext, shiftLen);
	population = new TypeIVGaPopulation(cleantext, this.solution, params, shiftLen, keyspec);
    }

    /**
     * analyzeText() performs a frequency analysis of the ciphertext.
     * @param text -- the ciphertext
     * @param shiftlen -- the length of the shift keyword
     */
    private void analyzeText(String text, int shiftlen) {
	FastIC ic = new FastIC(text, shiftlen);
	for (int j = 0; j < shiftlen; j++) {
	    FrequencyRecord freqs[] = ic.getSortedColumn(j);
	    for (int k = 0; k < freqs.length; k++)
		System.out.print(freqs[k].toString() + " ");
	    System.out.println();
	}
    }

    /**
     * run() the GA and report the results. 
     */
    public void run() {
        population.run();  
    }
}

