/*
 * File: WordBasedGaAnalyzer.java
 * @author R. Morelli <ralph.morelli@trincoll.edu> 
 * @author R. Walde <rwalde@nyc.rr.com> 
 * 
 * Description: This class assumes that the text is
 *  encrypted with simple substitution and uses a
 *  word-based genetic algorithm to analyze it.
 */

package analyzers;

import hcrypto.analyzer.*;
import hcrypto.cipher.*;
import hcrypto.engines.*;
import hcrypto.provider.*;

public class WordBasedGaAnalyzer extends GaAnalyzer implements Analyzer {
    
    /**
     * WordBasedGaAnalyzer() -- Default constructor
     */
    public WordBasedGaAnalyzer() {
	super();
    }

    /**
     * WordBasedGaAnalyzer() -- this constructor is given an object containing parameter settings
     * @param params -- an object containing param1=val1 param2=val2 ...
     */
    public WordBasedGaAnalyzer(GaParameters params) {
	super(params);
    }

    /**
     * gaSetup() implements the abstract gaSetup() method, inherited from the
     *   GaAnalyzer class by creating a WordBasedGAPopulation object. 
     */
    public void gaSetup()  {
	if (params == null) {
	    params = new GaParameters();       // Default GaParameters
	}
	population = new WordBasedGaPopulation(text, params);
    }

}

