/* 
 * File: AnalyzerFrame.java
 * Author: R. Morelli
 * Description: An implementation of a Frame subclass with window closer
 *  that can be subclassed or used by Analyzers for reporting analysis results.
 */

package hcrypto.analyzer;       // Analyzer plugins belong to this package
import analyzers.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class AnalyzerFrame extends Frame implements ActionListener {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 300;

    protected TextArea display;
    private CryptoAnalyzer analyzer; // The associated analyzer
    private MenuBar menubar;
    private Menu controls;
    private MenuItem stopItem, startItem;
    private String crypto;
    private String paramStr;
    private boolean stopThread = false;

    public AnalyzerFrame() {
	super("AnalyzerWindow");
	buildGUI();
    }

    public AnalyzerFrame(CryptoAnalyzer a, String text, String params) {
	super("AnalyzerWindow");
	analyzer = a;
	crypto = text;
	paramStr = params;
	buildGUI();
	analyzer.setup(crypto, this);
	stopThread = false;
	Thread t = new Thread(analyzer);
	t.start();                                      // Calls the analyzer's run() method
    }
    
    public void actionPerformed(ActionEvent e) {
	MenuItem m = (MenuItem)e.getSource();
	if (m == stopItem) {
	    stopThread = true;
	    analyzer.stopThread();
	}
	else if (m == startItem) {
	    analyzer.stopThread();
	    analyzer.setup(crypto, this);
	    stopThread = false;
	    Thread t = new Thread(analyzer);
	    t.start();                                      // Calls the analyzer's run() method
	}
    }

    protected void buildGUI() {
	menubar = new MenuBar();
	setMenuBar(menubar);
        controls = new Menu("Controls");
	menubar.add(controls);
	startItem = new MenuItem("Start");
	startItem.addActionListener(this);
	controls.add(startItem);
	stopItem = new MenuItem("Stop");
	stopItem.addActionListener(this);
	controls.add(stopItem);
	if (analyzer == null) {
	    stopItem.setEnabled(false);
	    startItem.setEnabled(false);
	}

	display = new TextArea(10,40);
	display.setEditable(false);
	add(display);
	setSize(WIDTH, HEIGHT);
	setVisible(true);
	centerWindow(this);
        this.addWindowListener(new WindowAdapter() {

            public void windowClosing(WindowEvent evt) {
                setVisible(false);
            } // windowClosing()
        });    //addWindowListener()
    }

    public static void centerWindow( Window win) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winSize = win.getSize();
        int x = (screenSize.width - winSize.width)/2;
        int y = (screenSize.height - winSize.height)/4;
        if (y < 0) 
            y = 0;
        win.setLocation(x, y);    
    }

    public void setText(String text) {
	display.setText(text);
    }

    public void append(String text) {
	display.append(text);
    }

    public boolean threadIsStopped() {
	return stopThread == true;
    }
}
