/* 
 * File: EnglishFacts.java
 * Author: R. Morelli
 * Description: This analyzer displays some facts about English text.
 */

package hcrypto.analyzer;     // This is where Analyzer is
import java.awt.*;
import java.awt.event.*;


public class EnglishFacts extends AnalyzerFrame implements Analyzer {

    private String text;             // Pointer to the text to be analyzed
    private StringBuffer resultSB = new StringBuffer();

    public EnglishFacts() {
	setTitle("English Facts");
	setSize(500,300);
	display.append("Facts about English Letter Frequencies\n");
    }
    
    
    /**
     * setup() is part of Analyzer interface. It passes in the pointer
     *  to the text.
     */     
    //    public void setup(TextArea text, TextArea display) { 
    public void setup(String text) { 
        this.text = text;
    }
    
    /**
     * run() is part of Analyzer interface. It performs the analysis.
     */     
    public void run() {
        resultSB.append("Most Frequent ...\n\n");
        resultSB.append("   Letters: E T A O N R I S H\n\n");
        resultSB.append("   Double Letters: LL EE SS OO TT FF RR NN PP CC MM GG\n\n");
        resultSB.append("   Two-letter Words: OF TO IN IS IT BY HE AS ON AT AN OR\n\n");
        resultSB.append("   Bigrams: TH HE AN RE ER IN ON AT ND ST ES EN\n\n");
        resultSB.append("   Three-letter Words: THE AND FOR ARE WAS BUT ONE HIS HAS HAD\n\n");
        resultSB.append("   Trigrams: ING ION ENT ERE TIO THA ATE AND EVE HAT VER HER\n\n");
        resultSB.append("   Initial Letters: T A O S W I H C B F P M\n\n");
	display.append(resultSB.toString() + "\n");
    }
    
    
    /**
     * getResult() is part of Analyzer interface. It returns the result
     *  as a string.
     */     
    public String getReport() {
	display.append(resultSB.toString() + "\n");
        return toString();
    }

    /**
     * toString() returns the result
     */     
    public String toString() {
        return resultSB.toString();
    }
}
