/*
 * File: FreqGaAnalyzer.java
 * @author R. Morelli <ralph.morelli@trincoll.edu> 
 * 
 * Description: This class assumes that the text is
 *  encrypted with simple substitution and uses a
 *  letter-frequency-based  genetic algorithm to analyze it.
 */

package analyzers;

import hcrypto.analyzer.*;
import hcrypto.cipher.*;
import hcrypto.engines.*;
import hcrypto.provider.*;

public class FreqGaAnalyzer extends CryptoAnalyzer implements Analyzer {
    
    protected GaPopulation population;

    /**
     * FreqGaAnalyzer() -- Default constructor
     */
    public FreqGaAnalyzer() {
	super();
    }

    /**
     * FreqGaAnalyzer() -- this constructor is given an object containing parameter settings
     * @param params -- an object containing param1=val1 param2=val2 ...
     */
    public FreqGaAnalyzer(GaParameters params) {
	super(params);
    }

    /**
     * gaSetup() implements the abstract gaSetup() method, inherited from the
     *   CryptoAnalyzer class by creating a FreqGAPopulation object. 
     */
    public void setup(String text) {
	super.setup(text);
	if (params == null) {
	    params = new GaParameters();       // Default GaParameters
	}
	population = new FreqGaPopulation(text, solution, params);
    }

    public void run() {
	population.run();
    }

}

