package hcrypto.analyzer;

import hcrypto.cipher.*;
import hcrypto.engines.*;
import hcrypto.provider.*;

public class FreqGaIndividual extends GaIndividual implements Comparable {

    private double english_digrams[][];
    private double crypto_digrams[][];
    private FrequencyRecord crypto_freqs[];   //single character frequencies
    private int d_key[];                  // The d_key maps a-->e(a), b-->e(b), etc.

    public FreqGaIndividual(int key[], double e_digrams[][], double
                            c_digrams[][], FrequencyRecord char_freqs[]) {
	super();
	d_key = new int[key.length];
	for (int k = 0; k < key.length; k++)          // Copy over the key
	    d_key[k] = key[k];
	d_key = key;
	english_digrams = e_digrams;
	crypto_digrams = c_digrams;
	crypto_freqs = char_freqs;
        calcFitness();
    }

    /**
     * This constructor takes an initial distribution for the key as
     *  a parameter. 
     * @param text -- A string giving the text to be decrypted.
     * @param initKey -- A string giving the initial values for the key.
     * @param p -- A pointer to the GaParameters
     */
    public FreqGaIndividual(String text, String initKey, GaParameters p) {
	super(text,initKey,p);
    }

    /**
     * Copy constructor
     */
    public FreqGaIndividual (GaIndividual i) {
	super(i);
	d_key = new int[27];
	for (int k = 0; k < 27; k++)               // Copy over the key
	    d_key[k] = ((FreqGaIndividual) i).d_key[k];
	english_digrams = ((FreqGaIndividual) i).english_digrams;
	crypto_digrams = ((FreqGaIndividual) i).crypto_digrams;
        crypto_freqs = ((FreqGaIndividual) i).crypto_freqs;
    }

    /** 
     * Implement a cross algorithm.
     */
    public void cross(GaIndividual i) {
	FreqGaIndividual i1 = this;
	FreqGaIndividual i2 = (FreqGaIndividual)i;
        cross(i1,i2);
        i1.calcFitness();
        i2.calcFitness();
    }

    public void cross(FreqGaIndividual i1, FreqGaIndividual i2) {
        int[] d_key1 = i1.d_key;
        int[] d_key2 = i2.d_key;
         
	/*************
	System.out.println("Before i1 key: " + i1.getKey());
	System.out.println("Before i2 key: " + i2.getKey());

        int[] child1 = new int[27];
        int[] child2 = new int[27];
        int[] arr = new int[27];
	int p1 = 0;
	int p2 = 0;
        for (int k=0; k < 26; k++) {
          if (crypto_freqs[d_key1[k]].count < crypto_freqs[d_key2[k]].count) { 
	      //              arr[k] = d_key1[k];      
              if (!isIn(child1,d_key2[k])) {     // if key2 not it child1                 
                  child1[p1++] = d_key2[k];      //  put it there
		  if (!isIn(arr,d_key1[k]) && !isIn(child1, d_key1[k])){ // If key1 not in arr
		      arr[p2++] = d_key1[k];                             //  put it there
		  } 
	      } else if (!isIn(child1,d_key1[k])) { // else key2 is in child1 if key1 not in child1
                  child1[p1++] = d_key1[k];         //  put it in there
		  //	      } else {                              // else both key2 and key1 are in child1
		  //		  if (!isIn(arr,d_key1[k])){                 
		  //		      arr[p2++] = d_key1[k]; 
		  //		  } 
		  //	      }
	      }
	  }
	  else if (crypto_freqs[d_key1[k]].count > crypto_freqs[d_key2[k]].count) {
              if (isIn(child1,d_key1[k]) == false ) {                 
                  child1[p1++] = d_key1[k]; 
		  if (!isIn(arr,d_key2[k]) && !isIn(child1, d_key2[k])){                 
		      arr[p2++] = d_key2[k]; 
		  } 
	      } else if (!isIn(child1, d_key2[k])) {
                  child1[p1++] = d_key2[k]; 
		  //	      } else if (!isIn(arr,d_key2[k])){                 
		  //		      arr[p2++] = d_key2[k]; 
		  //	      }
	      }
	  } else {
	      child1[p1++] = d_key2[k];
	  }
	  System.out.println(k + " " + p1 + " " + p2 + " " + (char)('a' + d_key1[k]) + " " + (char)('a' + d_key2[k]));
	}

	System.out.print("child1 ");
	for (int j = 0; j < p1; j++)
	    System.out.print((char)(child1[j] + 'a'));
	System.out.println();
	System.out.print("arr ");
	for (int j = 0; j < p2; j++)
	    System.out.print((char)(arr[j] + 'a'));
	System.out.println();
			     

	System.out.println("Before i2 key: " + i2.getKey());

	for (int k = 0; k < p2; k++)  // Copy unassigned characters
	    child1[p1++] = arr[k];

	child1[26] = '{' - 'a';

	arr = new int[27];
	p1 = p2 = 0;

	for (int k=25; k >=0; k--) {
          if (crypto_freqs[d_key1[k]].count < crypto_freqs[d_key2[k]].count) { 
              if (isIn(child2,d_key2[k]) == false ) {                 
                  child2[p1++] = d_key2[k]; 
	      } 
              if (isIn(child2,d_key1[k]) == false ) {                 
                  arr[p2++] = d_key1[k]; 
	      } 
	  }
	  else if (crypto_freqs[d_key1[k]].count > crypto_freqs[d_key2[k]].count) {
              if (isIn(child2,d_key1[k]) == false ) {                 
                  child2[p1++] = d_key1[k]; 
	      } 
              if (isIn(child2,d_key2[k]) == false ) {                 
                  arr[p2++] = d_key2[k]; 
	      } 
	  } else {
	      child2[p1++] = d_key2[k];
	  }
	}
	child2[26] = '{' - 'a';


	for (int k = 0; k < p2; k++)  // Copy unassigned characters
	    child1[p1++] = arr[k];
	
	for (int k = 0; k < i1.d_key.length; k++) {  // Copy the new keys
	     i1.d_key[k] = child1[k];
	     i2.d_key[k] = child2[k];
	 }

	System.out.println("After i1 key: " + i1.getKey());
	System.out.println("After i2 key: " + i2.getKey());
	*****************/
    } 

      public boolean isIn(int[] list, int m) {
          for (int k = 0; k < 26; k++) {
              if ( list[k] == m) return true; 
            }
          return false;
      }

    /**
     * This version of mutate swaps two random characters
     *  in the key. The mutation is done with frequency equal
     *  to rate. The resulting mutant is discarded if it
     *  does not improve the fitness of the individual.
     * @param rate is the mutation rate
     */
    public int mutate(double rate) {
        FreqGaIndividual tempIndy = new FreqGaIndividual(this);
	int a = 0, b = 0;

        if (Math.random() < rate) {
            a = (int)(Math.random() * 26);
            b = (int)(Math.random() * 26);
	}
	    
	//System.out.println("Mutate key: " + getKey());
	int ka = 0;
	while (d_key[ka] != a)  // Find a and b in arr
	    ka++;
	int kb = 0;
	while (d_key[kb] != b)
	    kb++;
	//	System.out.println(" " + (char)('a' + arr[ka]) + " " + (char)('a' + arr[kb]));
	int temp = d_key[ka];
	d_key[ka] = d_key[kb];
	d_key[kb] = temp;

	//            char ch = key.charAt(a);
	//            key.setCharAt(a, key.charAt(b));
	//            key.setCharAt(b, ch);
	this.calcFitness();

	if (this.getFitness() > tempIndy.getFitness())  {     // Mutate only if better
	    this.d_key = tempIndy.d_key;
	    this.fitness = tempIndy.fitness;
	    return 1;
	}
	return 0;
    }

    public void calcFitness() {
	double sum = 0;
	for (int j = 0; j < crypto_digrams.length; j++)
	    for (int k = 0; k < crypto_digrams.length; k++)
		sum += Math.abs(crypto_digrams[j][k] - english_digrams[d_key[j]][d_key[k]]);
	//		sum += Math.abs(crypto_digrams[d_key[j]][d_key[k]] - english_digrams[j][k]);
	fitness = sum;
        
    }

    public String displayCrossData() {
	return getKey() + " (" + getFitness() + ") ";
    }

    public String toString() {
	return getKey();
    }

    public String getKey() {
	StringBuffer sb = new StringBuffer();
	for (int k = 0; k < d_key.length; k++)
	    sb.append((char)(d_key[k] + 'a'));
	return sb.toString();
    }
}

