/*
 * File: FrequencyRecord.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * 
 * Description: Stores frequency data.
 *
 * Copyright: This program is in the public domain. You can do whatever you want with
 *  it as long as I get credit for my work and as long as you offer your changes to me
 *  so I can possible add them to the "official" version.
 */
package hcrypto.analyzer;

public class FrequencyRecord implements Comparable {
    //    protected char ch;
    //    protected int count = 0;
    public char ch;
    public int count = 0;

    public FrequencyRecord(char ch, int count) {
        this.ch = ch;
        this.count = count;
    }

    /**
     *  The copy constructor
     */
    public FrequencyRecord(FrequencyRecord freq) {
        this.ch = freq.ch;
        this.count = freq.count;
    }

    public String toString() {
        return this.ch +":" + this.count;
    }

    /**
     *  From the Comparable interface.
     */
    public int compareTo(Object o) {
        FrequencyRecord fr = (FrequencyRecord)o;
        if (this.count < fr.count)
            return -1;
        else if (this.count > fr.count)
            return +1;
        else
            return 0;
    }
}

