package hcrypto.analyzer;

import hcrypto.cipher.*;
import hcrypto.engines.*;
import hcrypto.provider.*;

public abstract class GaIndividual implements Comparable {
    protected StringBuffer key;
    protected double fitness;
    protected String ciphertext;
    protected String decrypt;
    protected Cipher cipher;
    protected SubstitutionKey sKey;
    protected GaParameters params;
    protected int mutate_policy = GaParameters.RANDOM_MUTATION;

    public GaIndividual() { // Default constructor
        key = new StringBuffer();
    }

    /**
     * This constructor takes an initial distribution for the key as
     *  a parameter. 
     * @param text -- A string giving the text to be decrypted.
     * @param initKey -- A string giving the initial values for the key.
     */
    public GaIndividual(String text, String initKey, GaParameters p) {
	ciphertext = text;
	params = p;
	key = new StringBuffer(initKey);
        try {
           Provider.addProvider(new DefaultProvider("Default"));
           cipher = Cipher.getInstance("Substitution");
           sKey = (SubstitutionKey) HistoricalKey.getInstance("Substitution", cipher.getProvider());
        } catch (Exception e) {
	    e.printStackTrace();
        }
	//        calcFitness();
	//	System.out.println("I key: " + initKey + " (" + fitness + ") " + getKey());
    }

    /**
     * Copy constructor
     */
    public GaIndividual (GaIndividual i) {
        key = new StringBuffer(i.key.toString());
        fitness = i.fitness;
        ciphertext = i.ciphertext;
        cipher = i.cipher;
        sKey = i.sKey;
	params = i.params;
	decrypt = i.decrypt;
	mutate_policy = i.mutate_policy;
    }

    /** 
     * This abstract method should be implemented in the subclass.
     *  @param i1 an Individual parent
     *  @param i2 an Individual parent
     */
    public abstract void cross(GaIndividual i2);

    /**
     * This method should be implemented in the subclass.
     * @param rate is the mutation rate
     */
    public abstract int mutate(double rate);

    /**
     * This method should be implemented in the subclass.
     */
    public abstract void calcFitness();


    protected void swap (char ch1, char ch2) {
	//	System.out.print("key " + key + " --> ");
        int m = key.toString().indexOf(ch1);
        int n = key.toString().indexOf(ch2);
        key.setCharAt(m, ch2);
        key.setCharAt(n, ch1);        
	//	System.out.println("Swap " + ch1 + " " + ch2 + " " + key);
    }


    public double getFitness() {
        return fitness;
    }

    public String getKey() {
        return key.toString();
    }

    public String getDecrypt() {
        return decrypt;
    }


    /**
     *  From the Comparable interface.
     */
    public int compareTo(Object o) {
        GaIndividual indy = (GaIndividual)o;
        if (this.fitness < indy.fitness)
            return +1;
        else if (this.fitness > indy.fitness)
            return -1;
        else
            return 0;
    }

    public String displayCrossData() {
	return getKey() + " (" + getFitness() + ")";
    }

    public String toString() {
	return getKey();
    }
}

