package hcrypto.analyzer;

import java.util.*;
import hcrypto.cipher.*;
import analyzers.*;

public class GaParameters {

    public static final int POPULATION_SIZE = 64;    // Parameter Defaults
    public static final int MAX_GENERATIONS = 500;  
    public static final int TWEAK_AT = 20;  
    public static final double MUTATE_RATE = 0.1;    
    public static final double CROSS_RATE = 0.75;    
    public static final boolean TWEAK_ON = true;    
    public static final boolean IS_VERBOSE = false;    

    public static final int NO_SEEDING = 0;
    public static final int RANDOM_SEEDING = 1;
    public static final int DETERMINISTIC_SEEDING = 2;
    public static final int ELITIST_SELECTION = 0;
    public static final int PROPORTIONAL_SELECTION = 1;
    public static final int ELITIST_MUTATION = 0;
    public static final int RANDOM_MUTATION = 1;


    public String param_string;
    public String filename;
    public double cross_rate = 0.75;      // Default values
    public double mutate_rate = 0.1;
    public int generations = 1000;
    public boolean verbose = false;
    public int text_limit = Analyzer.DECIPHER_LIMIT;
    public boolean tweaking = false;
    public int tweak_at = 0;
    public int size = 64;
    public int seeding = RANDOM_SEEDING;
    public int eval_dict = Dictionary.KUCERA_3500;
    public int seed_dict = Dictionary.KUCERA_50;
    public String dict_name = "words.txt";
    public double eval_A = 1;      // Evaluation parameters
    public double eval_B = 0.01;
    public double eval_C = 2;

    /** These are for GAs **/
    //    public int mutate_policy = RANDOM_MUTATION;
    public int mutate_policy = ELITIST_MUTATION;
    public int selection_policy = ELITIST_MUTATION;

    /** These are for NgramGaAnalyzers **/
    public Alphabet alphabet;
    public String book;
    public int NN = 4;       // Tetragram
    public int cipherType = NgramAnalyzer.SIMPLESUB; // Playfair
    public int randSize = 26;
    public int nloops = 5;

    /** These are for AnnealerAnalyzer **/
    public double temperature = 1.00;  // Temperature
    public double tFactor = 0.95;      // T = T * tFactor on each loop

    /** These are for all algorithms. **/
    public int nkeys = 100000;

    public GaParameters () { 
	try {
	    char arr[] = {'a','z',' ',' '};  // Default for NgramAnalyzers
	    alphabet = new Alphabet(arr);
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public GaParameters (String paramstr) {
	this.param_string = paramstr;
	StringTokenizer st = new StringTokenizer(paramstr);
	while (st.hasMoreTokens()) {
	    setParameters(st.nextToken());
	}
    }

    /**
     * setParameters parses the parameter string s to extract the
     *  names and values of the parameters.
     * @param s a String with the format param1=value1 param2=value2 ...
     */
    private void setParameters(String s) {
	String p_name = s.substring(0, s.indexOf("="));
	String p_val = s.substring(s.indexOf("=")+1);
	//	System.out.println("\tParamname: " + p_name  + "\tvalue: " + p_val);

	try {
	    char arr[] = {'a','z',' ',' '};  // Default for NgramAnalyzers
	    alphabet = new Alphabet(arr);
	} catch (Exception e) {
	    e.printStackTrace();
	}

	if (p_name.equals("file"))
	    filename = p_val;
	else if (p_name.equals("crossrate"))
	    cross_rate = Double.parseDouble(p_val);
	else if (p_name.equals("mutaterate"))
	    mutate_rate = Double.parseDouble(p_val);
	else if (p_name.equals("generations"))
	    generations = Integer.parseInt(p_val);
	else if (p_name.equals("verbose"))
	    verbose = p_val.equals("true");
	else if (p_name.equals("tweaking"))
	    tweaking = p_val.equals("true");
	else if (p_name.equals("textlimit"))
	    text_limit = Integer.parseInt(p_val);
	else if (p_name.equals("size"))
	    size = Integer.parseInt(p_val);
	else if (p_name.equals("seeding"))
	    seeding = Integer.parseInt(p_val);
	else if (p_name.equals("eDict"))
	    eval_dict = Integer.parseInt(p_val);
	else if (p_name.equals("sDict"))
	    seed_dict = Integer.parseInt(p_val);
	else if (p_name.equals("dict"))
	    dict_name = p_val;
	else if (p_name.equals("tweakat")) {
	    tweak_at = Integer.parseInt(p_val);
	    tweaking = tweak_at > 0;
	}
	else if (p_name.equals("A"))
	    eval_A = Double.parseDouble(p_val);
	else if (p_name.equals("B"))
	    eval_B = Double.parseDouble(p_val);
	else if (p_name.equals("C"))
	    eval_C = Double.parseDouble(p_val);
	else if (p_name.equals("book"))
	    book = p_val;
	else if (p_name.equals("ctype"))
	    cipherType = Integer.parseInt(p_val);
	else if (p_name.equals("rsize"))
	    randSize = Integer.parseInt(p_val);
	else if (p_name.equals("nloops"))
	    nloops = Integer.parseInt(p_val);
	else if (p_name.equals("NN"))
	    NN = Integer.parseInt(p_val);
	else if (p_name.equals("alpha")) {
	    try {
	    //	    System.out.println(p_name + " " + p_val);
		if (p_val.toLowerCase().equals("playfair")) {
		    char arr2[] = {'a','z'};
		    alphabet = new Alphabet(arr2);
		}
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
 	else if (p_name.equals("T"))
	    temperature = Double.parseDouble(p_val);
 	else if (p_name.equals("TFactor"))
	    tFactor = Double.parseDouble(p_val);
	else if (p_name.equals("nkeys"))
	    nkeys = Integer.parseInt(p_val);
	else if (p_name.equals("mutpol"))
	    mutate_policy = Integer.parseInt(p_val);
	else if (p_name.equals("selpol"))
	    selection_policy = Integer.parseInt(p_val);
	else if (p_name.equals("ss"))
	    shiftSeed = p_val;
	else if (p_name.equals("perm"))
	    permAlpha = p_val;
	else if (p_name.equals("phase"))
	    phase = Integer.parseInt(p_val);
    }

    public String toString() { return param_string; }
}
