package hcrypto.analyzer;

import java.awt.*;

public class IndexOfCoincidence implements Analyzer {
    private String text = null;
    private FrequencyTable ft;
    private double ioc = -1;    // -1 is an invalid IOC
    

    public IndexOfCoincidence() {
    }

    public IndexOfCoincidence(String text) {
        setup(text);
    }

    public double getIOC() {
	try {
            if (text == null)
                throw new Exception("ERROR: IndexOfCoincidence is not properly initialized");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ioc;
    }

    public void setup(String text) {
        this.text = text;
        ft = new FrequencyTable(text);
        ioc = computeIOC();
    }
        
    
    public void run() { /* Done in Setup */ }
    
    public String getReport() {
        return toString();
    }
    public String toString() {
        if (text != null) {
            java.text.NumberFormat nf = java.text.NumberFormat.getNumberInstance();
            nf.setMaximumFractionDigits(3); 
            return "Index of Coincidence = " + nf.format(ioc) + "\n";
        }
        return "This analyzer has not been setup() properly";
    }

    /**
     *  The coincidence index (CI) is a measure of the flatness
     *  of the frequency histogram for the file. This formula
     *  is derived in Beker and Piper, p 41 and also Sinkov, p. 68.
     *  It can be used to distinguish mono- and poly-alphabetic ciphers.
     *  Rules: For plaintext and monoalphabetic ciphers, the CI is around 0.065
     *         A completely flat histogram would be around 0.038
     */
    private double computeIOC() {
        int frequencies[] = ft.getFrequencies();
        int count = ft.getAlphabeticsCount();
        double sumFreqs = 0.0;
        for (int k = 'a'; k <= 'z' ; k++) {
            double freq = frequencies[k] + frequencies[k-32];
            sumFreqs = sumFreqs + freq * (freq - 1.0);
        }
	return sumFreqs / (count * (count - 1.0));
    }


}
