/*
 * File: LetterKeyMap.java
 * @author R. Morelli <ralph.morelli@trincoll.edu>
 * 
 * Description: Stores a letter and its location (typically 0-25) in a permutation key.
 *
 * Copyright: This program is in the public domain. You can do whatever you want with
 *  it as long as I get credit for my work and as long as you offer your changes to me
 *  so I can possible add them to the "official" version.
 */
package hcrypto.analyzer;

public class LetterKeyMap implements Comparable {
    public char ch;
    public int location = 0;

    public LetterKeyMap(char ch, int location) {
        this.ch = ch;
        this.location = location;
    }

    /**
     *  The copy constructor
     */
    public LetterKeyMap(LetterKeyMap keymap) {
        this.ch = keymap.ch;
        this.location = keymap.location;
    }

    public String toString() {
        return this.ch +":" + this.location;
    }


    /**
     *  From the Comparable interface.
     */
    public int compareTo(Object o) {
        LetterKeyMap map = (LetterKeyMap)o;
        if (this.location < map.location)
            return -1;
        else if (this.location > map.location)
            return +1;
        else
            return 0;
    }

}

