package hcrypto.analyzer;

import hcrypto.cipher.*;
import hcrypto.provider.*;

public abstract class NgramDecrypter {

    public static final int SIMPLESUB = 0;
    public static final int PERMUTATION = 1;
    public static final int RAILFENCE = 2;
    public static final int PLAYFAIR = 3;

    protected String cryptoText;
    protected int cipherType;
    protected Alphabet alphabet;
    protected NgramArray ngramArr;

    public NgramDecrypter() {}

    public abstract String getPlainText() throws Exception; 
    public abstract String decrypt() throws Exception;
    public abstract void randomizeClimb();
    public abstract void initClimb();
    public abstract void climb();
    public abstract void undostep();
    public abstract boolean hasMoreHill();
    public abstract void saveState();
    //    public abstract float currentEval() throws Exception;
    //    public abstract float bestEval() throws Exception;
    public abstract double currentEval() throws Exception;
    public abstract double bestEval() throws Exception;

    public int getCipherType() {
	return cipherType;
    }
    
    public String getCryptoText() {
	return cryptoText;
    }


    /********** UTILITY METHODS ************/

    /**
     * printarr() returns its array as String
     */
    protected String printarr(int arr[]) {
	StringBuffer sb = new StringBuffer();
	for (int k = 0; k < arr.length; k++)
	    sb.append(arr[k]);
	return sb.toString();
    }

    /**
     * randomize() randomly transposes the first N elements of
     *  an int array.
     */
    protected void randomize(int key[], int N) {
        int m;
        for (int k = 0; k < N; k++) {
            m = (int)(Math.random() * N);
            swap(key, k, m);
        } //for
    }

    /**
     * This method should be overridden in the subclass
     */
    public void swapInKey(int m, int n) {    }

    /**
     * swap(theArr, k, m) swaps theArr[k] with theArr[m]
     */
     protected void swap(int[] theArr, int k, int m){
       if (k != m){  // WARNING - Doesn't work
         theArr[m] = theArr[k] - theArr[m];  //Tricky swap to avoid allocating
         theArr[k] = theArr[k] - theArr[m];  //memory. Might be faster.
         theArr[m] = theArr[k] + theArr[m];  //Might not.
       } //if
     } //swap


    /**
     * copy(arr1, arr2) copies values of the elements of the array arr1
     * to the elements of the array arr2.  It is assumed that the arrays
     * have been constructed and are of the same size.
     */
     protected void copy(int[] arr1, int[] arr2){
         for (int k = 0; k < arr1.length; k++){
            arr2[k] = arr1[k];
         } //for
     } //swap


    protected String intarrToString(int[] arr) {
	StringBuffer sb = new StringBuffer();
	for (int k = 0; k < arr.length; k++)
	    sb.append(arr[k]);
	return sb.toString();
    }

    protected String intarrToChars(int[] arr) {
	StringBuffer sb = new StringBuffer();
	for (int k = 0; k < arr.length; k++)
	    sb.append((char)(arr[k] + 'a'));
	return sb.toString();
    }
    
    protected String revintarrToString(int[] arr) {
	StringBuffer sb = new StringBuffer("                           ");
	for (int k = 0; k < arr.length; k++)
	    sb.setCharAt(arr[k],(char)('a' + k));
	return sb.toString();
    }


}

