package hcrypto.analyzer;

import hcrypto.analyzer.*;

public class PatternWord implements Comparable {

    private String word;
    private String pattern;
    private double score;
    private double frequency;

    public PatternWord(String s, double freq) {
        word = new String(s.toLowerCase());
        pattern = new String(makePattern(s));
	frequency = freq;
	score = computeScore(pattern);
    }

    public String getWord() {
        return word;
    }

    public String getPattern() {
        return pattern;
    }

    public double getScore() {
        return score;
    }

    public double getFrequency() {
        return frequency;
    }

    private int computeScore(String s){
        int sum = 0;
        for (int k = 0; k < s.length(); k++) {
            char digit = s.charAt(k);
            if (Character.isDigit(digit))
		sum += digit - '0';
            else if (Character.isUpperCase(digit))
		sum += (10 + digit - 'A');
	}
        return sum;

    }

    /**
     * This method returns a pattern of the string. For example,
     *  if the word is "there" the pattern would be 12343. Words longer
     *  than 9 letters using UPPERCASE letters. For example, the
     *  word "appendectomy" would have the pattern "12234536789A".
     */
    public static String makePattern(String s) {
        String word = s.toLowerCase();
        String patternLetters = "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int p = 0;
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < Math.min(word.length(),patternLetters.length()); k++) {
            char ch = word.charAt(k);
            int index = word.substring(0,k).indexOf(ch);
            if (index == -1) {
                sb.append(patternLetters.charAt(p));
                ++p;
            }
            else
                sb.append(sb.charAt(index));
	}
        return sb.toString();
    }


    public int compareTo(Object o) {
        PatternWord t = (PatternWord)o;
        if (this.score < t.score)
	    return +1;
	else if (this.score > t.score)
	    return -1;
	else
	    return 0;
    }

}
