/* 
 * File: EnglishFacts.java
 * Author: R. Morelli
 * Description: This analyzer displays pattern words.
 */

package hcrypto.analyzer;     // This is where Analyzer is
import java.awt.*;
import java.awt.event.*;


public class PatternWordSearcher extends AnalyzerFrame 
            implements Analyzer, ActionListener {

    private String text;             // Pointer to the text to be analyzed
    private StringBuffer resultSB = new StringBuffer();
    private TextField tf;
    private PatternDictionary dict = new PatternDictionary(Dictionary.KUCERA_3500);
    private String descriptor;

    public PatternWordSearcher() {
	super();
	setTitle("Pattern Word Searcher");
	setSize(500,300);
	descriptor = dict.getDescriptor(Dictionary.KUCERA_3500);
        display.append("Using Dictionary " + descriptor + "\n");
	display.append("Type a pattern -- 12343 -- into the text field.\n");
    }
    
    /**
     * buildGUI() overrides the default method inherited from AnalyzerFrame.
     *  It is called in the super constructor.
     */
    protected void buildGUI() {
	setLayout(new FlowLayout());
	tf = new TextField("12343", 20);
	tf.addActionListener(this);
	add(tf);
	super.buildGUI();
	//	add(display);
    }

    public void actionPerformed(ActionEvent e){
	display.setText("Words with pattern " + tf.getText() + " in " + descriptor + "\n");
	display.append(dict.getWordList(tf.getText()));
    }
    
    /**
     * setup() is part of Analyzer interface. It passes in the pointer
     *  to the text.
     */     
    //    public void setup(TextArea text, TextArea display) { 
    public void setup(String text) { 
        this.text = text;
    }
    
    /**
     * run() is part of Analyzer interface. It performs the analysis.
     */     
    public void run() { }
    
    
    /**
     * getResult() is part of Analyzer interface. It returns the result
     *  as a string.
     */     
    public String getReport() {
        return "";
    }

    /**
     * toString() returns the result
     */     
    public String toString() {
        return resultSB.toString();
    }
}
