package hcrypto.analyzer;

import hcrypto.cipher.*;
import hcrypto.provider.*;

public class PermutationNgramDecrypter extends NgramDecrypter{

    private int MAX_BLOCKSIZE = 8;

    private int blocksize;
    private int key[];                      // For Permutation cipher key is array of ints
    private int bestkey[];
    private Cipher cipher;                  // Used for creating cipher decrypt engine
    private HistoricalKey historicalKey;

    private int j = 0, k = 0;               // Climber control variables

    public PermutationNgramDecrypter(String crypto, Alphabet alpha, NgramArray nga) {
	Provider.addProvider(new DefaultProvider("Default"));
	cipher = Cipher.getInstance("Transposition", "Default");
	historicalKey = HistoricalKey.getInstance(cipher.getAlgorithm(), cipher.getProvider());
	this.alphabet = alpha;
	this.cryptoText = crypto;
	this.cipherType = NgramAnalyzer.PERMUTATION;
	this.ngramArr = nga;
    }

    /*********** The following are abstract in the super class. ********/

    public String getPlainText() throws Exception {
	return decrypt(cryptoText, bestkey, alphabet);
    }

    public String decrypt() throws Exception {
	return decrypt(cryptoText, key, alphabet);
    }

    public void randomizeClimb() {
	key = getRandomKey();
    }

    public void initClimb() {
	j = 0;
	k = 1;
    }

    public void climb() {
	//	System.out.println(blocksize + " " + j + " " + k);
	swap(key, j, k);
    }

    public void undostep() {
	swap(key, j, k);
	j++;
	if (j >= k) { j = 0; k++; }
    }

    public boolean hasMoreHill() {
	return k < key.length;
    }

    public int getCipherType() {
	return cipherType;
    }

    public void saveState() {
	bestkey = new int[key.length];
	copy(key, bestkey);
    }

    public float currentEval() throws Exception {
	return ngramArr.recipDist(decrypt());
    }

    public float bestEval() throws Exception {
	return ngramArr.recipDist(getPlainText());
    }

    /*************** Private utility methods. ****************/

    private int[] getRandomKey() {
	int key[] = null;
	blocksize = 2 + (int)(Math.random() * MAX_BLOCKSIZE);   // Pick a random blocksize
	key = new int[blocksize];
	for (int k = 0; k < key.length; k++) 
	    key[k] = k;
	randomize(key, key.length); 
	return key;
    }

    private String decrypt(String cText, int[] key, Alphabet alpha) throws Exception {
	String keyword;
	keyword = intarrToString(key);
	historicalKey.init(keyword, alpha, alpha);
	cipher.init(historicalKey);
	return cipher.decrypt(cText);
    }

}
